/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.tool.output;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import org.apache.skywalking.oal.tool.output.AllDispatcherContext;
import org.apache.skywalking.oal.tool.output.DispatcherContext;
import org.apache.skywalking.oal.tool.output.WriteWrapper;
import org.apache.skywalking.oal.tool.parser.AnalysisResult;
import org.apache.skywalking.oal.tool.parser.DisableCollection;
import org.apache.skywalking.oal.tool.parser.OALScripts;

public class FileGenerator {
    private List<AnalysisResult> results;
    private DisableCollection collection;
    private String outputPath;
    private Configuration configuration;
    private AllDispatcherContext allDispatcherContext;

    public FileGenerator(OALScripts oalScripts, String outputPath) {
        this.results = oalScripts.getMetricsStmts();
        this.collection = oalScripts.getDisableCollection();
        this.outputPath = outputPath;
        this.configuration = new Configuration(new Version("2.3.28"));
        this.configuration.setEncoding(Locale.ENGLISH, "UTF-8");
        this.configuration.setClassLoaderForTemplateLoading(FileGenerator.class.getClassLoader(), "/code-templates");
        this.allDispatcherContext = new AllDispatcherContext();
        this.buildDispatcherContext();
    }

    public void generate() throws IOException, TemplateException {
        for (AnalysisResult result : this.results) {
            this.generate(result, "Metrics.java", writer -> this.generateMetricsImplementor(result, writer));
            String scopeName = result.getSourceName();
            File file = new File(this.outputPath, "generated/" + scopeName.toLowerCase() + "/" + scopeName + "Dispatcher.java");
            this.createFile(file);
            this.generateDispatcher(result, new FileWriter(file));
        }
        this.generateDisable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(AnalysisResult result, String fileSuffix, WriteWrapper writeWrapper) throws IOException, TemplateException {
        File file = new File(this.outputPath, this.buildSubFolderName(result, fileSuffix));
        this.createFile(file);
        try (FileWriter fileWriter = new FileWriter(file);){
            writeWrapper.execute(fileWriter);
        }
    }

    private void createFile(File file) throws IOException {
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
    }

    private String buildSubFolderName(AnalysisResult result, String suffix) {
        return "generated/" + result.getSourceName().toLowerCase() + "/" + result.getMetricsName() + suffix;
    }

    void generateMetricsImplementor(AnalysisResult result, Writer output) throws IOException, TemplateException {
        this.configuration.getTemplate("MetricsImplementor.ftl").process((Object)result, output);
    }

    void generateDispatcher(AnalysisResult result, Writer output) throws IOException, TemplateException {
        String scopeName = result.getSourceName();
        DispatcherContext context = this.allDispatcherContext.getAllContext().get(scopeName);
        if (context != null) {
            this.configuration.getTemplate("DispatcherTemplate.ftl").process((Object)context, output);
        }
    }

    private void buildDispatcherContext() {
        for (AnalysisResult result : this.results) {
            String sourceName = result.getSourceName();
            DispatcherContext context = this.allDispatcherContext.getAllContext().get(sourceName);
            if (context == null) {
                context = new DispatcherContext();
                context.setSource(sourceName);
                context.setPackageName(sourceName.toLowerCase());
                this.allDispatcherContext.getAllContext().put(sourceName, context);
            }
            context.getMetrics().add(result);
        }
    }

    private void generateDisable() throws IOException, TemplateException {
        File file = new File(this.outputPath, "generated/DisableSourceDefinition.java");
        this.createFile(file);
        this.configuration.getTemplate("DisableSourceDefinition.ftl").process((Object)this.collection, (Writer)new FileWriter(file));
    }
}

