/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.tool.parser;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.oal.tool.parser.ConditionExpression;
import org.apache.skywalking.oal.tool.parser.DataColumn;
import org.apache.skywalking.oal.tool.parser.EntryMethod;
import org.apache.skywalking.oal.tool.parser.FilterExpression;
import org.apache.skywalking.oal.tool.parser.PersistenceColumns;
import org.apache.skywalking.oal.tool.parser.SourceColumn;

public class AnalysisResult {
    private String varName;
    private String metricsName;
    private String tableName;
    private String packageName;
    private String sourceName;
    private int sourceScopeId;
    private String sourceAttribute;
    private String aggregationFunctionName;
    private String metricsClassName;
    private EntryMethod entryMethod;
    private List<FilterExpression> filterExpressions;
    private List<ConditionExpression> filterExpressionsParserResult;
    private List<ConditionExpression> funcConditionExpressions;
    private List<String> funcArgs;
    private int argGetIdx = 0;
    private List<DataColumn> persistentFields;
    private List<SourceColumn> fieldsFromSource;
    private PersistenceColumns serializeFields;

    public void addPersistentField(String fieldName, String columnName, Class<?> type) {
        if (this.persistentFields == null) {
            this.persistentFields = new LinkedList<DataColumn>();
        }
        DataColumn dataColumn = new DataColumn(fieldName, columnName, type);
        this.persistentFields.add(dataColumn);
    }

    public void addFuncConditionExpression(ConditionExpression conditionExpression) {
        if (this.funcConditionExpressions == null) {
            this.funcConditionExpressions = new LinkedList<ConditionExpression>();
        }
        this.funcConditionExpressions.add(conditionExpression);
    }

    public void addFilterExpressions(FilterExpression filterExpression) {
        if (this.filterExpressions == null) {
            this.filterExpressions = new LinkedList<FilterExpression>();
        }
        this.filterExpressions.add(filterExpression);
    }

    public void addFilterExpressionsParserResult(ConditionExpression conditionExpression) {
        if (this.filterExpressionsParserResult == null) {
            this.filterExpressionsParserResult = new LinkedList<ConditionExpression>();
        }
        this.filterExpressionsParserResult.add(conditionExpression);
    }

    public void addFuncArg(String value) {
        if (this.funcArgs == null) {
            this.funcArgs = new LinkedList<String>();
        }
        this.funcArgs.add(value);
    }

    public String getNextFuncArg() {
        return this.funcArgs.get(this.argGetIdx++);
    }

    public void generateSerializeFields() {
        String type;
        this.serializeFields = new PersistenceColumns();
        block26: for (SourceColumn sourceColumn : this.fieldsFromSource) {
            switch (type = sourceColumn.getType().getSimpleName()) {
                case "int": {
                    this.serializeFields.addIntField(sourceColumn.getFieldName());
                    continue block26;
                }
                case "double": {
                    this.serializeFields.addDoubleField(sourceColumn.getFieldName());
                    continue block26;
                }
                case "String": {
                    this.serializeFields.addStringField(sourceColumn.getFieldName());
                    continue block26;
                }
                case "long": {
                    this.serializeFields.addLongField(sourceColumn.getFieldName());
                    continue block26;
                }
            }
            throw new IllegalStateException("Unexpected field type [" + type + "] of source sourceColumn [" + sourceColumn.getFieldName() + "]");
        }
        block27: for (DataColumn column : this.persistentFields) {
            switch (type = column.getType().getSimpleName()) {
                case "int": {
                    this.serializeFields.addIntField(column.getFieldName());
                    continue block27;
                }
                case "double": {
                    this.serializeFields.addDoubleField(column.getFieldName());
                    continue block27;
                }
                case "String": {
                    this.serializeFields.addStringField(column.getFieldName());
                    continue block27;
                }
                case "long": {
                    this.serializeFields.addLongField(column.getFieldName());
                    continue block27;
                }
                case "IntKeyLongValueArray": {
                    this.serializeFields.addIntLongValuePairelistField(column.getFieldName());
                    continue block27;
                }
            }
            throw new IllegalStateException("Unexpected field type [" + type + "] of persistence column [" + column.getFieldName() + "]");
        }
    }

    public String getVarName() {
        return this.varName;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getSourceScopeId() {
        return this.sourceScopeId;
    }

    public String getSourceAttribute() {
        return this.sourceAttribute;
    }

    public String getAggregationFunctionName() {
        return this.aggregationFunctionName;
    }

    public String getMetricsClassName() {
        return this.metricsClassName;
    }

    public EntryMethod getEntryMethod() {
        return this.entryMethod;
    }

    public List<FilterExpression> getFilterExpressions() {
        return this.filterExpressions;
    }

    public List<ConditionExpression> getFilterExpressionsParserResult() {
        return this.filterExpressionsParserResult;
    }

    public List<ConditionExpression> getFuncConditionExpressions() {
        return this.funcConditionExpressions;
    }

    public List<String> getFuncArgs() {
        return this.funcArgs;
    }

    public int getArgGetIdx() {
        return this.argGetIdx;
    }

    public List<DataColumn> getPersistentFields() {
        return this.persistentFields;
    }

    public List<SourceColumn> getFieldsFromSource() {
        return this.fieldsFromSource;
    }

    public PersistenceColumns getSerializeFields() {
        return this.serializeFields;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setSourceScopeId(int sourceScopeId) {
        this.sourceScopeId = sourceScopeId;
    }

    public void setSourceAttribute(String sourceAttribute) {
        this.sourceAttribute = sourceAttribute;
    }

    public void setAggregationFunctionName(String aggregationFunctionName) {
        this.aggregationFunctionName = aggregationFunctionName;
    }

    public void setMetricsClassName(String metricsClassName) {
        this.metricsClassName = metricsClassName;
    }

    public void setEntryMethod(EntryMethod entryMethod) {
        this.entryMethod = entryMethod;
    }

    public void setFilterExpressions(List<FilterExpression> filterExpressions) {
        this.filterExpressions = filterExpressions;
    }

    public void setFilterExpressionsParserResult(List<ConditionExpression> filterExpressionsParserResult) {
        this.filterExpressionsParserResult = filterExpressionsParserResult;
    }

    public void setFuncConditionExpressions(List<ConditionExpression> funcConditionExpressions) {
        this.funcConditionExpressions = funcConditionExpressions;
    }

    public void setFuncArgs(List<String> funcArgs) {
        this.funcArgs = funcArgs;
    }

    public void setArgGetIdx(int argGetIdx) {
        this.argGetIdx = argGetIdx;
    }

    public void setPersistentFields(List<DataColumn> persistentFields) {
        this.persistentFields = persistentFields;
    }

    public void setFieldsFromSource(List<SourceColumn> fieldsFromSource) {
        this.fieldsFromSource = fieldsFromSource;
    }

    public void setSerializeFields(PersistenceColumns serializeFields) {
        this.serializeFields = serializeFields;
    }
}

