/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.tool.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import org.apache.skywalking.oal.tool.parser.AnalysisResult;
import org.apache.skywalking.oal.tool.parser.ConditionExpression;
import org.apache.skywalking.oal.tool.parser.EntryMethod;
import org.apache.skywalking.oal.tool.parser.FilterExpression;
import org.apache.skywalking.oal.tool.parser.MetricsHolder;
import org.apache.skywalking.oal.tool.parser.SourceColumn;
import org.apache.skywalking.oal.tool.parser.SourceColumnsFactory;
import org.apache.skywalking.oal.tool.util.ClassMethodUtil;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Arg;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ConstOne;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Expression;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ExpressionArg0;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ExpressionArg1;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

public class DeepAnalysis {
    public AnalysisResult analysis(AnalysisResult result) {
        result.setPackageName(result.getSourceName().toLowerCase());
        Class<? extends Metrics> metricsClass = MetricsHolder.find(result.getAggregationFunctionName());
        String metricsClassSimpleName = metricsClass.getSimpleName();
        result.setMetricsClassName(metricsClassSimpleName);
        List<ConditionExpression> expressions = result.getFilterExpressionsParserResult();
        if (expressions != null && expressions.size() > 0) {
            for (ConditionExpression expression : expressions) {
                FilterExpression filterExpression = new FilterExpression();
                if ("booleanMatch".equals(expression.getExpressionType())) {
                    filterExpression.setExpressionObject("EqualMatch");
                    filterExpression.setLeft("source." + ClassMethodUtil.toIsMethod(expression.getAttribute()) + "()");
                    filterExpression.setRight(expression.getValue());
                    result.addFilterExpressions(filterExpression);
                    continue;
                }
                if ("stringMatch".equals(expression.getExpressionType())) {
                    filterExpression.setExpressionObject("EqualMatch");
                    filterExpression.setLeft("source." + ClassMethodUtil.toGetMethod(expression.getAttribute()) + "()");
                    filterExpression.setRight(expression.getValue());
                    result.addFilterExpressions(filterExpression);
                    continue;
                }
                if ("greaterMatch".equals(expression.getExpressionType())) {
                    filterExpression.setExpressionObject("GreaterMatch");
                    filterExpression.setLeft("source." + ClassMethodUtil.toGetMethod(expression.getAttribute()) + "()");
                    filterExpression.setRight(expression.getValue());
                    result.addFilterExpressions(filterExpression);
                    continue;
                }
                if ("lessMatch".equals(expression.getExpressionType())) {
                    filterExpression.setExpressionObject("LessMatch");
                    filterExpression.setLeft("source." + ClassMethodUtil.toGetMethod(expression.getAttribute()) + "()");
                    filterExpression.setRight(expression.getValue());
                    result.addFilterExpressions(filterExpression);
                    continue;
                }
                if ("greaterEqualMatch".equals(expression.getExpressionType())) {
                    filterExpression.setExpressionObject("GreaterEqualMatch");
                    filterExpression.setLeft("source." + ClassMethodUtil.toGetMethod(expression.getAttribute()) + "()");
                    filterExpression.setRight(expression.getValue());
                    result.addFilterExpressions(filterExpression);
                    continue;
                }
                if ("lessEqualMatch".equals(expression.getExpressionType())) {
                    filterExpression.setExpressionObject("LessEqualMatch");
                    filterExpression.setLeft("source." + ClassMethodUtil.toGetMethod(expression.getAttribute()) + "()");
                    filterExpression.setRight(expression.getValue());
                    result.addFilterExpressions(filterExpression);
                    continue;
                }
                throw new IllegalArgumentException("filter expression [" + expression.getExpressionType() + "] not found");
            }
        }
        Class<? extends Metrics> c = metricsClass;
        Method entranceMethod = null;
        block1: while (!c.equals(Object.class)) {
            for (Method method : c.getMethods()) {
                Entrance entrance = method.getAnnotation(Entrance.class);
                if (entrance == null) continue;
                entranceMethod = method;
                break block1;
            }
            c = c.getSuperclass();
        }
        if (entranceMethod == null) {
            throw new IllegalArgumentException("Can't find Entrance method in class: " + metricsClass.getName());
        }
        EntryMethod entryMethod = new EntryMethod();
        result.setEntryMethod(entryMethod);
        entryMethod.setMethodName(entranceMethod.getName());
        for (Parameter parameter : entranceMethod.getParameters()) {
            ConditionExpression conditionExpression;
            Annotation[] parameterAnnotations = parameter.getAnnotations();
            if (parameterAnnotations == null || parameterAnnotations.length == 0) {
                throw new IllegalArgumentException("Entrance method:" + entranceMethod + " doesn't include the annotation.");
            }
            Annotation annotation = parameterAnnotations[0];
            if (annotation instanceof SourceFrom) {
                entryMethod.addArg("source." + ClassMethodUtil.toGetMethod(result.getSourceAttribute()) + "()");
                continue;
            }
            if (annotation instanceof ConstOne) {
                entryMethod.addArg("1");
                continue;
            }
            if (annotation instanceof Expression) {
                entryMethod.addArg("new " + parameter.getType().getName() + "()");
                continue;
            }
            if (annotation instanceof ExpressionArg0) {
                if (result.getFuncConditionExpressions().size() == 1) {
                    conditionExpression = result.getFuncConditionExpressions().get(0);
                    if ("booleanMatch".equals(conditionExpression.getExpressionType())) {
                        entryMethod.addArg("source." + ClassMethodUtil.toIsMethod(conditionExpression.getAttribute()) + "()");
                        continue;
                    }
                    if ("stringMatch".equals(conditionExpression.getExpressionType())) {
                        entryMethod.addArg("source." + ClassMethodUtil.toGetMethod(conditionExpression.getAttribute()) + "()");
                        continue;
                    }
                    throw new IllegalArgumentException("Entrance method:" + entranceMethod + " argument has @ExpressionArg0, but expression type is not supported");
                }
                throw new IllegalArgumentException("Entrance method:" + entranceMethod + " argument has @ExpressionArg0, but can't find funcParamExpression.");
            }
            if (annotation instanceof ExpressionArg1) {
                if (result.getFuncConditionExpressions().size() == 1) {
                    conditionExpression = result.getFuncConditionExpressions().get(0);
                    entryMethod.addArg(conditionExpression.getValue());
                    continue;
                }
                throw new IllegalArgumentException("Entrance method:" + entranceMethod + " argument has @ExpressionArg0, but can't find funcParamExpression.");
            }
            if (annotation instanceof Arg) {
                entryMethod.addArg(result.getNextFuncArg());
                continue;
            }
            throw new IllegalArgumentException("Entrance method:" + entranceMethod + " doesn't the expected annotation.");
        }
        c = metricsClass;
        while (!c.equals(Object.class)) {
            for (AnnotatedElement annotatedElement : c.getDeclaredFields()) {
                Column column = ((Field)annotatedElement).getAnnotation(Column.class);
                if (column == null) continue;
                result.addPersistentField(((Field)annotatedElement).getName(), column.columnName(), ((Field)annotatedElement).getType());
            }
            c = c.getSuperclass();
        }
        List<SourceColumn> columns = SourceColumnsFactory.getColumns(result.getSourceName());
        result.setFieldsFromSource(columns);
        result.generateSerializeFields();
        return result;
    }
}

