/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.tool.parser;

import java.util.List;
import org.antlr.v4.runtime.misc.NotNull;
import org.apache.skywalking.oal.tool.grammar.OALParser;
import org.apache.skywalking.oal.tool.grammar.OALParserBaseListener;
import org.apache.skywalking.oal.tool.parser.AnalysisResult;
import org.apache.skywalking.oal.tool.parser.ConditionExpression;
import org.apache.skywalking.oal.tool.parser.DeepAnalysis;
import org.apache.skywalking.oal.tool.parser.DisableCollection;
import org.apache.skywalking.oal.tool.parser.OALScripts;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;

public class OALListener
extends OALParserBaseListener {
    private List<AnalysisResult> results;
    private AnalysisResult current;
    private DisableCollection collection;
    private ConditionExpression conditionExpression;

    public OALListener(OALScripts scripts) {
        this.results = scripts.getMetricsStmts();
        this.collection = scripts.getDisableCollection();
    }

    public void enterAggregationStatement(@NotNull OALParser.AggregationStatementContext ctx) {
        this.current = new AnalysisResult();
    }

    public void exitAggregationStatement(@NotNull OALParser.AggregationStatementContext ctx) {
        DeepAnalysis deepAnalysis = new DeepAnalysis();
        this.results.add(deepAnalysis.analysis(this.current));
        this.current = null;
    }

    public void enterSource(OALParser.SourceContext ctx) {
        this.current.setSourceName(ctx.getText());
        this.current.setSourceScopeId(DefaultScopeDefine.valueOf((String)this.metricsNameFormat(ctx.getText())));
    }

    public void enterSourceAttribute(OALParser.SourceAttributeContext ctx) {
        this.current.setSourceAttribute(ctx.getText());
    }

    public void enterVariable(OALParser.VariableContext ctx) {
    }

    public void exitVariable(OALParser.VariableContext ctx) {
        this.current.setVarName(ctx.getText());
        this.current.setMetricsName(this.metricsNameFormat(ctx.getText()));
        this.current.setTableName(ctx.getText().toLowerCase());
    }

    public void enterFunctionName(OALParser.FunctionNameContext ctx) {
        this.current.setAggregationFunctionName(ctx.getText());
    }

    public void enterFilterStatement(OALParser.FilterStatementContext ctx) {
        this.conditionExpression = new ConditionExpression();
    }

    public void exitFilterStatement(OALParser.FilterStatementContext ctx) {
        this.current.addFilterExpressionsParserResult(this.conditionExpression);
        this.conditionExpression = null;
    }

    public void enterFuncParamExpression(OALParser.FuncParamExpressionContext ctx) {
        this.conditionExpression = new ConditionExpression();
    }

    public void exitFuncParamExpression(OALParser.FuncParamExpressionContext ctx) {
        this.current.addFuncConditionExpression(this.conditionExpression);
        this.conditionExpression = null;
    }

    public void enterConditionAttribute(OALParser.ConditionAttributeContext ctx) {
        this.conditionExpression.setAttribute(ctx.getText());
    }

    public void enterBooleanMatch(OALParser.BooleanMatchContext ctx) {
        this.conditionExpression.setExpressionType("booleanMatch");
    }

    public void enterStringMatch(OALParser.StringMatchContext ctx) {
        this.conditionExpression.setExpressionType("stringMatch");
    }

    public void enterGreaterMatch(OALParser.GreaterMatchContext ctx) {
        this.conditionExpression.setExpressionType("greaterMatch");
    }

    public void enterGreaterEqualMatch(OALParser.GreaterEqualMatchContext ctx) {
        this.conditionExpression.setExpressionType("greaterEqualMatch");
    }

    public void enterLessMatch(OALParser.LessMatchContext ctx) {
        this.conditionExpression.setExpressionType("lessMatch");
    }

    public void enterLessEqualMatch(OALParser.LessEqualMatchContext ctx) {
        this.conditionExpression.setExpressionType("lessEqualMatch");
    }

    public void enterBooleanConditionValue(OALParser.BooleanConditionValueContext ctx) {
        this.conditionExpression.setValue(ctx.getText());
    }

    public void enterStringConditionValue(OALParser.StringConditionValueContext ctx) {
        this.conditionExpression.setValue(ctx.getText());
    }

    public void enterEnumConditionValue(OALParser.EnumConditionValueContext ctx) {
        this.conditionExpression.setValue(ctx.getText());
    }

    public void enterNumberConditionValue(OALParser.NumberConditionValueContext ctx) {
        this.conditionExpression.setValue(ctx.getText());
    }

    public void enterLiteralExpression(OALParser.LiteralExpressionContext ctx) {
        this.current.addFuncArg(ctx.getText());
    }

    private String metricsNameFormat(String source) {
        int idx;
        source = this.firstLetterUpper(source);
        while ((idx = source.indexOf("_")) > -1) {
            source = source.substring(0, idx) + this.firstLetterUpper(source.substring(idx + 1));
        }
        return source;
    }

    public void enterDisableSource(OALParser.DisableSourceContext ctx) {
        this.collection.add(ctx.getText());
    }

    private String firstLetterUpper(String source) {
        return source.substring(0, 1).toUpperCase() + source.substring(1);
    }
}

