/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.tool.parser;

import java.io.IOException;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.skywalking.oal.tool.grammar.OALLexer;
import org.apache.skywalking.oal.tool.grammar.OALParser;
import org.apache.skywalking.oal.tool.parser.OALListener;
import org.apache.skywalking.oal.tool.parser.OALScripts;

public class ScriptParser {
    private OALLexer lexer;

    private ScriptParser() {
    }

    public static ScriptParser createFromFile(String scriptFilepath) throws IOException {
        ScriptParser parser = new ScriptParser();
        parser.lexer = new OALLexer(CharStreams.fromFileName((String)scriptFilepath));
        return parser;
    }

    public static ScriptParser createFromScriptText(String script) throws IOException {
        ScriptParser parser = new ScriptParser();
        parser.lexer = new OALLexer((CharStream)CharStreams.fromString((String)script));
        return parser;
    }

    public OALScripts parse() throws IOException {
        OALScripts scripts = new OALScripts();
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)this.lexer);
        OALParser parser = new OALParser((TokenStream)tokens);
        OALParser.RootContext tree = parser.root();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)new OALListener(scripts), (ParseTree)tree);
        return scripts;
    }

    public void close() {
    }
}

