/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.buffer;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Parser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import org.apache.commons.io.FileUtils;
import org.apache.skywalking.oap.server.library.buffer.DataStream;
import org.apache.skywalking.oap.server.library.buffer.DataStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferStream<MESSAGE_TYPE extends GeneratedMessageV3> {
    private static final Logger logger = LoggerFactory.getLogger(BufferStream.class);
    private final String absolutePath;
    private final boolean cleanWhenRestart;
    private final int dataFileMaxSize;
    private final int offsetFileMaxSize;
    private final Parser<MESSAGE_TYPE> parser;
    private final DataStreamReader.CallBack<MESSAGE_TYPE> callBack;
    private DataStream<MESSAGE_TYPE> dataStream;

    private BufferStream(String absolutePath, boolean cleanWhenRestart, int dataFileMaxSize, int offsetFileMaxSize, Parser<MESSAGE_TYPE> parser, DataStreamReader.CallBack<MESSAGE_TYPE> callBack) {
        this.absolutePath = absolutePath;
        this.cleanWhenRestart = cleanWhenRestart;
        this.dataFileMaxSize = dataFileMaxSize;
        this.offsetFileMaxSize = offsetFileMaxSize;
        this.parser = parser;
        this.callBack = callBack;
    }

    public synchronized void initialize() throws IOException {
        File directory = new File(this.absolutePath);
        FileUtils.forceMkdir((File)directory);
        this.tryLock(directory);
        this.dataStream = new DataStream<MESSAGE_TYPE>(directory, this.dataFileMaxSize, this.offsetFileMaxSize, this.parser, this.callBack);
        if (this.cleanWhenRestart) {
            this.dataStream.clean();
        }
        this.dataStream.initialize();
    }

    public synchronized void write(AbstractMessageLite messageLite) {
        this.dataStream.getWriter().write(messageLite);
    }

    private void tryLock(File directory) {
        logger.info("Try to lock buffer directory, directory is: " + directory.getAbsolutePath());
        FileLock lock = null;
        try {
            lock = new FileOutputStream(new File(directory, "lock")).getChannel().tryLock();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (lock == null) {
            throw new RuntimeException("The buffer directory is reading or writing by another thread, directory is: " + directory.getAbsolutePath());
        }
        logger.info("Lock buffer directory successfully, directory is: " + directory.getAbsolutePath());
    }

    public static class Builder<MESSAGE_TYPE extends GeneratedMessageV3> {
        private final String absolutePath;
        private boolean cleanWhenRestart;
        private int dataFileMaxSize;
        private int offsetFileMaxSize;
        private Parser<MESSAGE_TYPE> parser;
        private DataStreamReader.CallBack<MESSAGE_TYPE> callBack;

        public Builder(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        public BufferStream<MESSAGE_TYPE> build() {
            return new BufferStream(this.absolutePath, this.cleanWhenRestart, this.dataFileMaxSize, this.offsetFileMaxSize, this.parser, this.callBack);
        }

        public Builder<MESSAGE_TYPE> cleanWhenRestart(boolean cleanWhenRestart) {
            this.cleanWhenRestart = cleanWhenRestart;
            return this;
        }

        public Builder<MESSAGE_TYPE> offsetFileMaxSize(int offsetFileMaxSize) {
            this.offsetFileMaxSize = offsetFileMaxSize;
            return this;
        }

        public Builder<MESSAGE_TYPE> dataFileMaxSize(int dataFileMaxSize) {
            this.dataFileMaxSize = dataFileMaxSize;
            return this;
        }

        public Builder<MESSAGE_TYPE> parser(Parser<MESSAGE_TYPE> parser) {
            this.parser = parser;
            return this;
        }

        public Builder<MESSAGE_TYPE> callBack(DataStreamReader.CallBack<MESSAGE_TYPE> callBack) {
            this.callBack = callBack;
            return this;
        }
    }
}

