/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.buffer;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Parser;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.skywalking.oap.server.library.buffer.DataStreamReader;
import org.apache.skywalking.oap.server.library.buffer.DataStreamWriter;
import org.apache.skywalking.oap.server.library.buffer.OffsetStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataStream<MESSAGE_TYPE extends GeneratedMessageV3> {
    private static final Logger logger = LoggerFactory.getLogger(DataStream.class);
    private final File directory;
    private final OffsetStream offsetStream;
    private final DataStreamReader<MESSAGE_TYPE> reader;
    private final DataStreamWriter<MESSAGE_TYPE> writer;
    private boolean initialized = false;

    DataStream(File directory, int dataFileMaxSize, int offsetFileMaxSize, Parser<MESSAGE_TYPE> parser, DataStreamReader.CallBack<MESSAGE_TYPE> callBack) {
        this.directory = directory;
        this.offsetStream = new OffsetStream(directory, offsetFileMaxSize);
        this.writer = new DataStreamWriter(directory, this.offsetStream.getOffset().getWriteOffset(), dataFileMaxSize);
        this.reader = new DataStreamReader<MESSAGE_TYPE>(directory, this.offsetStream.getOffset().getReadOffset(), parser, callBack);
    }

    void clean() throws IOException {
        String[] fileNames = this.directory.list((FilenameFilter)new PrefixFileFilter("data"));
        if (fileNames != null) {
            for (String fileName : fileNames) {
                File file = new File(this.directory, fileName);
                if (logger.isDebugEnabled()) {
                    logger.debug("Delete buffer data file: {}", (Object)file.getAbsolutePath());
                }
                FileUtils.forceDelete((File)file);
            }
        }
        this.offsetStream.clean();
    }

    synchronized void initialize() throws IOException {
        if (!this.initialized) {
            this.offsetStream.initialize();
            this.writer.initialize();
            this.reader.initialize();
            this.initialized = true;
        }
    }

    public DataStreamReader<MESSAGE_TYPE> getReader() {
        return this.reader;
    }

    public DataStreamWriter<MESSAGE_TYPE> getWriter() {
        return this.writer;
    }
}

