/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.buffer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;
import org.apache.skywalking.oap.server.library.buffer.BufferFileUtils;
import org.apache.skywalking.oap.server.library.buffer.Offset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OffsetStream {
    private static final Logger logger = LoggerFactory.getLogger(OffsetStream.class);
    private final File directory;
    private final int offsetFileMaxSize;
    private final Offset offset;
    private File offsetFile;
    private boolean initialized = false;
    private String lastOffsetRecord = "";

    OffsetStream(File directory, int offsetFileMaxSize) {
        this.directory = directory;
        this.offsetFileMaxSize = offsetFileMaxSize;
        this.offset = new Offset();
    }

    void clean() throws IOException {
        String[] fileNames = this.directory.list((FilenameFilter)new PrefixFileFilter("offset"));
        if (fileNames != null) {
            for (String fileName : fileNames) {
                File file = new File(this.directory, fileName);
                if (logger.isDebugEnabled()) {
                    logger.debug("Delete buffer offset file: {}", (Object)file.getAbsolutePath());
                }
                FileUtils.forceDelete((File)new File(this.directory, fileName));
            }
        }
    }

    synchronized void initialize() throws IOException {
        if (!this.initialized) {
            String[] fileNames = this.directory.list((FilenameFilter)new PrefixFileFilter("offset"));
            if (fileNames != null && fileNames.length > 0) {
                BufferFileUtils.sort(fileNames);
                this.offsetFile = new File(this.directory, fileNames[0]);
            } else {
                this.offsetFile = this.newFile();
            }
            this.offset.deserialize(this.readLastLine());
            this.initialized = true;
            Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)new RunnableWithExceptionProtection(this::flush, t -> logger.error("Flush offset file in background failure.", t)), 2L, 1L, TimeUnit.SECONDS);
        }
    }

    void flush() {
        block15: {
            try {
                String offsetRecord = this.offset.serialize();
                if (this.lastOffsetRecord.equals(offsetRecord)) break block15;
                logger.debug("flush offset, record: {}", (Object)offsetRecord);
                if (this.offsetFile.length() >= 0x100000L * (long)this.offsetFileMaxSize) {
                    this.nextFile();
                }
                try (BufferedOutputStream out = new BufferedOutputStream(FileUtils.openOutputStream((File)this.offsetFile, (boolean)true));){
                    IOUtils.write((String)offsetRecord, (OutputStream)out, (Charset)Charset.forName("UTF-8"));
                    IOUtils.write((String)System.lineSeparator(), (OutputStream)out, (Charset)Charset.forName("UTF-8"));
                }
                this.lastOffsetRecord = offsetRecord;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private void nextFile() throws IOException {
        File newOffsetFile = this.newFile();
        if (!this.offsetFile.delete()) {
            logger.warn("Offset file {} delete failure.", (Object)newOffsetFile.getAbsolutePath());
        }
        this.offsetFile = newOffsetFile;
        this.flush();
    }

    private File newFile() throws IOException {
        String fileName = BufferFileUtils.buildFileName("offset");
        File file = new File(this.directory, fileName);
        if (file.createNewFile()) {
            logger.info("Create a new offset file {}", (Object)fileName);
        }
        return file;
    }

    private String readLastLine() throws IOException {
        ReversedLinesFileReader reader = new ReversedLinesFileReader(this.offsetFile, Charset.forName("UTF-8"));
        return reader.readLine();
    }

    public Offset getOffset() {
        return this.offset;
    }
}

