/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.client.elasticsearch;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.NameSpace;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchClient
implements Client {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchClient.class);
    private static final String TYPE = "type";
    private final String clusterNodes;
    private final NameSpace namespace;
    private RestHighLevelClient client;

    public ElasticSearchClient(String clusterNodes, NameSpace namespace) {
        this.clusterNodes = clusterNodes;
        this.namespace = namespace;
    }

    @Override
    public void initialize() {
        List<HttpHost> pairsList = this.parseClusterNodes(this.clusterNodes);
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])pairsList.toArray(new HttpHost[0])));
    }

    @Override
    public void shutdown() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<HttpHost> parseClusterNodes(String nodes) {
        String[] nodesSplit;
        LinkedList<HttpHost> httpHosts = new LinkedList<HttpHost>();
        logger.info("elasticsearch cluster nodes: {}", (Object)nodes);
        for (String node : nodesSplit = nodes.split(",")) {
            String host = node.split(":")[0];
            String port = node.split(":")[1];
            httpHosts.add(new HttpHost(host, Integer.valueOf(port).intValue()));
        }
        return httpHosts;
    }

    public boolean createIndex(String indexName, Settings settings, XContentBuilder mappingBuilder) throws IOException {
        indexName = this.formatIndexName(indexName);
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        request.settings(settings);
        request.mapping(TYPE, mappingBuilder);
        CreateIndexResponse response = this.client.indices().create(request, new Header[0]);
        logger.info("create {} index finished, isAcknowledged: {}", (Object)indexName, (Object)response.isAcknowledged());
        return response.isAcknowledged();
    }

    public boolean deleteIndex(String indexName) throws IOException {
        indexName = this.formatIndexName(indexName);
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        DeleteIndexResponse response = this.client.indices().delete(request, new Header[0]);
        logger.info("delete {} index finished, isAcknowledged: {}", (Object)indexName, (Object)response.isAcknowledged());
        return response.isAcknowledged();
    }

    public boolean isExistsIndex(String indexName) throws IOException {
        indexName = this.formatIndexName(indexName);
        GetIndexRequest request = new GetIndexRequest();
        request.indices(new String[]{indexName});
        return this.client.indices().exists(request, new Header[0]);
    }

    public SearchResponse search(String indexName, SearchSourceBuilder searchSourceBuilder) throws IOException {
        indexName = this.formatIndexName(indexName);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.types(new String[]{TYPE});
        searchRequest.source(searchSourceBuilder);
        return this.client.search(searchRequest, new Header[0]);
    }

    public GetResponse get(String indexName, String id) throws IOException {
        indexName = this.formatIndexName(indexName);
        GetRequest request = new GetRequest(indexName, TYPE, id);
        return this.client.get(request, new Header[0]);
    }

    public MultiGetResponse multiGet(String indexName, List<String> ids) throws IOException {
        String newIndexName = this.formatIndexName(indexName);
        MultiGetRequest request = new MultiGetRequest();
        ids.forEach(id -> request.add(newIndexName, TYPE, id));
        return this.client.multiGet(request, new Header[0]);
    }

    public void forceInsert(String indexName, String id, XContentBuilder source) throws IOException {
        IndexRequest request = this.prepareInsert(indexName, id, source);
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.index(request, new Header[0]);
    }

    public void forceUpdate(String indexName, String id, XContentBuilder source, long version) throws IOException {
        indexName = this.formatIndexName(indexName);
        UpdateRequest request = this.prepareUpdate(indexName, id, source);
        request.version(version);
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.update(request, new Header[0]);
    }

    public void forceUpdate(String indexName, String id, XContentBuilder source) throws IOException {
        indexName = this.formatIndexName(indexName);
        UpdateRequest request = this.prepareUpdate(indexName, id, source);
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.update(request, new Header[0]);
    }

    public IndexRequest prepareInsert(String indexName, String id, XContentBuilder source) {
        indexName = this.formatIndexName(indexName);
        return new IndexRequest(indexName, TYPE, id).source(source);
    }

    public UpdateRequest prepareUpdate(String indexName, String id, XContentBuilder source) {
        indexName = this.formatIndexName(indexName);
        return new UpdateRequest(indexName, TYPE, id).doc(source);
    }

    public int delete(String indexName, String timeBucketColumnName, long endTimeBucket) throws IOException {
        indexName = this.formatIndexName(indexName);
        Map<String, String> params = Collections.singletonMap("conflicts", "proceed");
        String jsonString = "{  \"query\": {    \"range\": {      \"" + timeBucketColumnName + "\": {        \"lte\": " + endTimeBucket + "      }    }  }}";
        NStringEntity entity = new NStringEntity(jsonString, ContentType.APPLICATION_JSON);
        Response response = this.client.getLowLevelClient().performRequest("POST", "/" + indexName + "/_delete_by_query", params, (HttpEntity)entity, new Header[0]);
        return response.getStatusLine().getStatusCode();
    }

    private String formatIndexName(String indexName) {
        if (Objects.nonNull(this.namespace) && StringUtils.isNotEmpty((CharSequence)this.namespace.getNameSpace())) {
            return this.namespace.getNameSpace() + "_" + indexName;
        }
        return indexName;
    }

    public BulkProcessor createBulkProcessor(int bulkActions, int bulkSize, int flushInterval, int concurrentRequests) {
        BulkProcessor.Listener listener = new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                logger.error("{} data bulk failed, reason: {}", (Object)request.numberOfActions(), (Object)failure);
            }
        };
        return BulkProcessor.builder((x$0, x$1) -> this.client.bulkAsync(x$0, x$1, new Header[0]), (BulkProcessor.Listener)listener).setBulkActions(bulkActions).setBulkSize(new ByteSizeValue((long)bulkSize, ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds((long)flushInterval)).setConcurrentRequests(concurrentRequests).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)100L), (int)3)).build();
    }
}

