/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.client.grpc;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.apache.skywalking.oap.server.library.client.Client;

public class GRPCClient
implements Client {
    private final String host;
    private final int port;
    private ManagedChannel channel;

    public GRPCClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void initialize() {
        this.channel = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext(true).build();
    }

    @Override
    public void shutdown() {
        this.channel.shutdownNow();
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

