/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.client.grpc;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCClient
implements Client {
    private static final Logger logger = LoggerFactory.getLogger(GRPCClient.class);
    private final String host;
    private final int port;
    private SslContext sslContext;
    private ManagedChannel channel;

    public GRPCClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public GRPCClient(String host, int port, SslContext sslContext) {
        this(host, port);
        this.sslContext = sslContext;
    }

    @Override
    public void connect() {
        if (this.sslContext == null) {
            this.channel = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext().build();
            return;
        }
        this.channel = NettyChannelBuilder.forAddress((String)this.host, (int)this.port).sslContext(this.sslContext).build();
    }

    @Override
    public void shutdown() {
        try {
            this.channel.shutdownNow();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }
}

