/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.client.elasticsearch;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearch;
import org.apache.skywalking.library.elasticsearch.ElasticSearchBuilder;
import org.apache.skywalking.library.elasticsearch.bulk.BulkProcessor;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.library.elasticsearch.response.Document;
import org.apache.skywalking.library.elasticsearch.response.Documents;
import org.apache.skywalking.library.elasticsearch.response.Index;
import org.apache.skywalking.library.elasticsearch.response.IndexTemplate;
import org.apache.skywalking.library.elasticsearch.response.Mappings;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.elasticsearch.IndexRequestWrapper;
import org.apache.skywalking.oap.server.library.client.elasticsearch.UpdateRequestWrapper;
import org.apache.skywalking.oap.server.library.client.healthcheck.DelegatedHealthChecker;
import org.apache.skywalking.oap.server.library.client.healthcheck.HealthCheckable;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchClient
implements Client,
HealthCheckable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchClient.class);
    public static final String TYPE = "type";
    private final String clusterNodes;
    private final String protocol;
    private final String trustStorePath;
    private volatile String trustStorePass;
    private volatile String user;
    private volatile String password;
    private final Function<String, String> indexNameConverter;
    private final DelegatedHealthChecker healthChecker = new DelegatedHealthChecker();
    private final int connectTimeout;
    private final int socketTimeout;
    private final int responseTimeout;
    private final int numHttpClientThread;
    private final AtomicReference<ElasticSearch> es = new AtomicReference();

    public ElasticSearchClient(String clusterNodes, String protocol, String trustStorePath, String trustStorePass, String user, String password, Function<String, String> indexNameConverter, int connectTimeout, int socketTimeout, int responseTimeout, int numHttpClientThread) {
        this.clusterNodes = clusterNodes;
        this.protocol = protocol;
        this.trustStorePath = trustStorePath;
        this.trustStorePass = trustStorePass;
        this.user = user;
        this.password = password;
        this.indexNameConverter = indexNameConverter;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.responseTimeout = responseTimeout;
        this.numHttpClientThread = numHttpClientThread;
    }

    @Override
    public void connect() {
        ElasticSearch oldOne = this.es.get();
        ElasticSearchBuilder cb = ElasticSearch.builder().endpoints(this.clusterNodes.split(",")).protocol(this.protocol).connectTimeout(this.connectTimeout).responseTimeout(this.responseTimeout).socketTimeout(this.socketTimeout).numHttpClientThread(this.numHttpClientThread).healthyListener(healthy -> {
            if (healthy.booleanValue()) {
                this.healthChecker.health();
            } else {
                this.healthChecker.unHealth("No healthy endpoint");
            }
        });
        if (!Strings.isNullOrEmpty((String)this.trustStorePath)) {
            cb.trustStorePath(this.trustStorePath);
        }
        if (!Strings.isNullOrEmpty((String)this.trustStorePass)) {
            cb.trustStorePass(this.trustStorePass);
        }
        if (!Strings.isNullOrEmpty((String)this.user)) {
            cb.username(this.user);
        }
        if (!Strings.isNullOrEmpty((String)this.password)) {
            cb.password(this.password);
        }
        ElasticSearch newOne = cb.build();
        CompletableFuture f = newOne.connect();
        f.whenComplete((ignored, exception) -> {
            if (exception != null) {
                log.error("Failed to recreate ElasticSearch client based on config", exception);
                return;
            }
            if (this.es.compareAndSet(oldOne, newOne)) {
                oldOne.close();
            } else {
                newOne.close();
            }
        });
        f.join();
    }

    @Override
    public void shutdown() {
        this.es.get().close();
    }

    @Override
    public void registerChecker(HealthChecker healthChecker) {
        this.healthChecker.register(healthChecker);
    }

    public boolean createIndex(String indexName) {
        return this.createIndex(indexName, null, null);
    }

    public boolean createIndex(String indexName, Mappings mappings, Map<String, ?> settings) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().index().create(indexName, mappings, settings);
    }

    public boolean updateIndexMapping(String indexName, Mappings mapping) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().index().putMapping(indexName, TYPE, mapping);
    }

    public Optional<Index> getIndex(String indexName) {
        if (StringUtil.isBlank((String)indexName)) {
            return Optional.empty();
        }
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().index().get(indexName);
    }

    public Collection<String> retrievalIndexByAliases(String alias) {
        alias = this.indexNameConverter.apply(alias);
        return this.es.get().alias().indices(alias).keySet();
    }

    public boolean deleteByIndexName(String indexName) {
        return this.es.get().index().delete(indexName);
    }

    public boolean isExistsIndex(String indexName) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().index().exists(indexName);
    }

    public Optional<IndexTemplate> getTemplate(String name) {
        name = this.indexNameConverter.apply(name);
        return this.es.get().templates().get(name);
    }

    public boolean isExistsTemplate(String indexName) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().templates().exists(indexName);
    }

    public boolean createOrUpdateTemplate(String indexName, Map<String, Object> settings, Mappings mapping, int order) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().templates().createOrUpdate(indexName, settings, mapping, order);
    }

    public boolean deleteTemplate(String indexName) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().templates().delete(indexName);
    }

    public SearchResponse search(Supplier<String[]> indices, Search search) {
        String[] indexNames = (String[])Arrays.stream(indices.get()).map(this.indexNameConverter).toArray(String[]::new);
        SearchParams params = new SearchParams().allowNoIndices(true).ignoreUnavailable(true).expandWildcards("open");
        return this.es.get().search(search, params, indexNames);
    }

    public SearchResponse search(String indexName, Search search) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().search(search, new String[]{indexName});
    }

    public SearchResponse search(String indexName, Search search, SearchParams params) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().search(search, params, new String[]{indexName});
    }

    public SearchResponse scroll(Duration contextRetention, String scrollId) {
        return this.es.get().scroll(contextRetention, scrollId);
    }

    public boolean deleteScrollContextQuietly(String scrollId) {
        try {
            return this.es.get().deleteScrollContext(scrollId);
        }
        catch (Exception e) {
            log.warn("Failed to delete scroll context: {}", (Object)scrollId, (Object)e);
            return false;
        }
    }

    public Optional<Document> get(String indexName, String id) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().documents().get(indexName, TYPE, id);
    }

    public boolean existDoc(String indexName, String id) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().documents().exists(indexName, TYPE, id);
    }

    public Optional<Documents> ids(Map<String, List<String>> indexIds) {
        HashMap map = new HashMap();
        indexIds.forEach((indexName, ids) -> map.put(this.indexNameConverter.apply((String)indexName), ids));
        return this.es.get().documents().mget(TYPE, map);
    }

    public SearchResponse searchIDs(String indexName, Iterable<String> ids) {
        indexName = this.indexNameConverter.apply(indexName);
        return this.es.get().search(Search.builder().size(Integer.valueOf(Iterables.size(ids))).query((QueryBuilder)Query.ids(ids)).build(), new String[]{indexName});
    }

    public void forceInsert(String indexName, String id, Map<String, Object> source) {
        IndexRequestWrapper wrapper = this.prepareInsert(indexName, id, source);
        ImmutableMap params = ImmutableMap.of((Object)"refresh", (Object)"true");
        this.es.get().documents().index(wrapper.getRequest(), (Map)params);
    }

    public void forceUpdate(String indexName, String id, Map<String, Object> source) {
        UpdateRequestWrapper wrapper = this.prepareUpdate(indexName, id, source);
        ImmutableMap params = ImmutableMap.of((Object)"refresh", (Object)"true");
        this.es.get().documents().update(wrapper.getRequest(), (Map)params);
    }

    public IndexRequestWrapper prepareInsert(String indexName, String id, Map<String, Object> source) {
        return this.prepareInsert(indexName, id, Optional.empty(), source);
    }

    public IndexRequestWrapper prepareInsert(String indexName, String id, Optional<String> routingValue, Map<String, Object> source) {
        indexName = this.indexNameConverter.apply(indexName);
        return new IndexRequestWrapper(indexName, TYPE, id, routingValue, source);
    }

    public UpdateRequestWrapper prepareUpdate(String indexName, String id, Map<String, Object> source) {
        indexName = this.indexNameConverter.apply(indexName);
        return new UpdateRequestWrapper(indexName, TYPE, id, source);
    }

    public BulkProcessor createBulkProcessor(int bulkActions, int flushInterval, int concurrentRequests, int batchOfBytes) {
        return BulkProcessor.builder().bulkActions(bulkActions).batchOfBytes(batchOfBytes).flushInterval(Duration.ofSeconds(flushInterval)).concurrentRequests(concurrentRequests).build(this.es);
    }

    public String formatIndexName(String indexName) {
        return this.indexNameConverter.apply(indexName);
    }

    @Generated
    public ElasticSearchClient(String clusterNodes, String protocol, String trustStorePath, Function<String, String> indexNameConverter, int connectTimeout, int socketTimeout, int responseTimeout, int numHttpClientThread) {
        this.clusterNodes = clusterNodes;
        this.protocol = protocol;
        this.trustStorePath = trustStorePath;
        this.indexNameConverter = indexNameConverter;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.responseTimeout = responseTimeout;
        this.numHttpClientThread = numHttpClientThread;
    }

    @Generated
    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }
}

