/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql;

import com.coxautodev.graphql.tools.GraphQLResolver;
import com.coxautodev.graphql.tools.SchemaParser;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import org.apache.skywalking.oap.query.graphql.GraphQLQueryConfig;
import org.apache.skywalking.oap.query.graphql.GraphQLQueryHandler;
import org.apache.skywalking.oap.query.graphql.resolver.AggregationQuery;
import org.apache.skywalking.oap.query.graphql.resolver.AlarmQuery;
import org.apache.skywalking.oap.query.graphql.resolver.MetadataQuery;
import org.apache.skywalking.oap.query.graphql.resolver.MetricQuery;
import org.apache.skywalking.oap.query.graphql.resolver.Mutation;
import org.apache.skywalking.oap.query.graphql.resolver.Query;
import org.apache.skywalking.oap.query.graphql.resolver.TopologyQuery;
import org.apache.skywalking.oap.query.graphql.resolver.TraceQuery;
import org.apache.skywalking.oap.server.core.query.QueryModule;
import org.apache.skywalking.oap.server.core.server.JettyHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.jetty.JettyHandler;

public class GraphQLQueryProvider
extends ModuleProvider {
    private final GraphQLQueryConfig config = new GraphQLQueryConfig();
    private GraphQL graphQL;

    public String name() {
        return "graphql";
    }

    public Class<? extends ModuleDefine> module() {
        return QueryModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        GraphQLSchema schema = SchemaParser.newParser().file("query-protocol/common.graphqls").resolvers(new GraphQLResolver[]{new Query(), new Mutation()}).file("query-protocol/metadata.graphqls").resolvers(new GraphQLResolver[]{new MetadataQuery(this.getManager())}).file("query-protocol/metric.graphqls").resolvers(new GraphQLResolver[]{new MetricQuery(this.getManager())}).file("query-protocol/topology.graphqls").resolvers(new GraphQLResolver[]{new TopologyQuery(this.getManager())}).file("query-protocol/trace.graphqls").resolvers(new GraphQLResolver[]{new TraceQuery(this.getManager())}).file("query-protocol/aggregation.graphqls").resolvers(new GraphQLResolver[]{new AggregationQuery(this.getManager())}).file("query-protocol/alarm.graphqls").resolvers(new GraphQLResolver[]{new AlarmQuery(this.getManager())}).build().makeExecutableSchema();
        this.graphQL = GraphQL.newGraphQL((GraphQLSchema)schema).build();
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        JettyHandlerRegister service = (JettyHandlerRegister)this.getManager().find("core").provider().getService(JettyHandlerRegister.class);
        service.addHandler((JettyHandler)new GraphQLQueryHandler(this.config.getPath(), this.graphQL));
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[0];
    }
}

