/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.query.graphql.type.Duration;
import org.apache.skywalking.oap.server.core.query.AggregationQueryService;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.entity.Order;
import org.apache.skywalking.oap.server.core.query.entity.TopNEntity;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class AggregationQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private AggregationQueryService queryService;

    public AggregationQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private AggregationQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (AggregationQueryService)this.moduleManager.find("core").provider().getService(AggregationQueryService.class);
        }
        return this.queryService;
    }

    public List<TopNEntity> getServiceTopN(String name, int topN, Duration duration, Order order) throws IOException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getQueryService().getServiceTopN(name, topN, duration.getStep(), startTimeBucket, endTimeBucket, order);
    }

    public List<TopNEntity> getAllServiceInstanceTopN(String name, int topN, Duration duration, Order order) throws IOException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getQueryService().getAllServiceInstanceTopN(name, topN, duration.getStep(), startTimeBucket, endTimeBucket, order);
    }

    public List<TopNEntity> getServiceInstanceTopN(int serviceId, String name, int topN, Duration duration, Order order) throws IOException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getQueryService().getServiceInstanceTopN(serviceId, name, topN, duration.getStep(), startTimeBucket, endTimeBucket, order);
    }

    public List<TopNEntity> getAllEndpointTopN(String name, int topN, Duration duration, Order order) throws IOException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getQueryService().getAllEndpointTopN(name, topN, duration.getStep(), startTimeBucket, endTimeBucket, order);
    }

    public List<TopNEntity> getEndpointTopN(int serviceId, String name, int topN, Duration duration, Order order) throws IOException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getQueryService().getEndpointTopN(serviceId, name, topN, duration.getStep(), startTimeBucket, endTimeBucket, order);
    }
}

