/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import java.io.IOException;
import org.apache.skywalking.oap.query.graphql.type.Duration;
import org.apache.skywalking.oap.server.core.query.AlarmQueryService;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.entity.AlarmTrend;
import org.apache.skywalking.oap.server.core.query.entity.Alarms;
import org.apache.skywalking.oap.server.core.query.entity.Pagination;
import org.apache.skywalking.oap.server.core.source.Scope;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class AlarmQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private AlarmQueryService queryService;

    public AlarmQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private AlarmQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (AlarmQueryService)this.moduleManager.find("core").getService(AlarmQueryService.class);
        }
        return this.queryService;
    }

    public AlarmTrend getAlarmTrend(Duration duration) {
        return new AlarmTrend();
    }

    public Alarms getAlarm(Duration duration, Scope scope, String keyword, Pagination paging) throws IOException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getQueryService().getAlarm(scope, keyword, paging, startTimeBucket, endTimeBucket);
    }
}

