/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.text.ParseException;
import org.apache.skywalking.oap.query.graphql.type.BatchMetricConditions;
import org.apache.skywalking.oap.query.graphql.type.Duration;
import org.apache.skywalking.oap.query.graphql.type.MetricCondition;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.MetricQueryService;
import org.apache.skywalking.oap.server.core.query.entity.IntValues;
import org.apache.skywalking.oap.server.core.query.entity.Thermodynamic;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class MetricQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private MetricQueryService metricQueryService;

    public MetricQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private MetricQueryService getMetricQueryService() {
        if (this.metricQueryService == null) {
            this.metricQueryService = (MetricQueryService)this.moduleManager.find("core").getService(MetricQueryService.class);
        }
        return this.metricQueryService;
    }

    public IntValues getValues(BatchMetricConditions metric, Duration duration) throws IOException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getMetricQueryService().getValues(metric.getName(), metric.getIds(), duration.getStep(), startTimeBucket, endTimeBucket);
    }

    public IntValues getLinearIntValues(MetricCondition metric, Duration duration) throws IOException, ParseException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getMetricQueryService().getLinearIntValues(metric.getName(), metric.getId(), duration.getStep(), startTimeBucket, endTimeBucket);
    }

    public Thermodynamic getThermodynamic(MetricCondition metric, Duration duration) throws IOException, ParseException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getMetricQueryService().getThermodynamic(metric.getName(), metric.getId(), duration.getStep(), startTimeBucket, endTimeBucket);
    }
}

