/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.query.graphql.type.TopNRecordsCondition;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.TopNRecordsQueryService;
import org.apache.skywalking.oap.server.core.query.entity.Order;
import org.apache.skywalking.oap.server.core.query.entity.TopNRecord;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class TopNRecordsQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private TopNRecordsQueryService topNRecordsQueryService;

    public TopNRecordsQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private TopNRecordsQueryService getTopNRecordsQueryService() {
        if (this.topNRecordsQueryService == null) {
            this.topNRecordsQueryService = (TopNRecordsQueryService)this.moduleManager.find("core").provider().getService(TopNRecordsQueryService.class);
        }
        return this.topNRecordsQueryService;
    }

    public List<TopNRecord> getTopNRecords(TopNRecordsCondition condition) throws IOException {
        long startSecondTB = DurationUtils.INSTANCE.startTimeDurationToSecondTimeBucket(condition.getDuration().getStep(), condition.getDuration().getStart());
        long endSecondTB = DurationUtils.INSTANCE.endTimeDurationToSecondTimeBucket(condition.getDuration().getStep(), condition.getDuration().getEnd());
        String metricName = condition.getMetricName();
        Order order = condition.getOrder();
        int topN = condition.getTopN();
        int serviceId = condition.getServiceId();
        return this.getTopNRecordsQueryService().getTopNRecords(startSecondTB, endSecondTB, metricName, serviceId, topN, order);
    }
}

