/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.apache.skywalking.oap.query.graphql.type.BatchMetricConditions;
import org.apache.skywalking.oap.query.graphql.type.Duration;
import org.apache.skywalking.oap.query.graphql.type.MetricCondition;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.MetricQueryService;
import org.apache.skywalking.oap.server.core.query.StepToDownsampling;
import org.apache.skywalking.oap.server.core.query.entity.IntValues;
import org.apache.skywalking.oap.server.core.query.entity.Step;
import org.apache.skywalking.oap.server.core.query.entity.Thermodynamic;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class MetricQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private MetricQueryService metricQueryService;

    public MetricQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private MetricQueryService getMetricQueryService() {
        if (this.metricQueryService == null) {
            this.metricQueryService = (MetricQueryService)this.moduleManager.find("core").provider().getService(MetricQueryService.class);
        }
        return this.metricQueryService;
    }

    public IntValues getValues(BatchMetricConditions metrics, Duration duration) throws IOException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getMetricQueryService().getValues(metrics.getName(), metrics.getIds(), StepToDownsampling.transform((Step)duration.getStep()), startTimeBucket, endTimeBucket);
    }

    public IntValues getLinearIntValues(MetricCondition metrics, Duration duration) throws IOException, ParseException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getMetricQueryService().getLinearIntValues(metrics.getName(), metrics.getId(), StepToDownsampling.transform((Step)duration.getStep()), startTimeBucket, endTimeBucket);
    }

    public List<IntValues> getMultipleLinearIntValues(MetricCondition metrics, int numOfLinear, Duration duration) throws IOException, ParseException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getMetricQueryService().getMultipleLinearIntValues(metrics.getName(), metrics.getId(), numOfLinear, StepToDownsampling.transform((Step)duration.getStep()), startTimeBucket, endTimeBucket);
    }

    public List<IntValues> getSubsetOfMultipleLinearIntValues(MetricCondition metrics, List<Integer> linearIndex, Duration duration) throws IOException, ParseException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getMetricQueryService().getSubsetOfMultipleLinearIntValues(metrics.getName(), metrics.getId(), linearIndex, StepToDownsampling.transform((Step)duration.getStep()), startTimeBucket, endTimeBucket);
    }

    public Thermodynamic getThermodynamic(MetricCondition metrics, Duration duration) throws IOException, ParseException {
        long startTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getStart());
        long endTimeBucket = DurationUtils.INSTANCE.exchangeToTimeBucket(duration.getEnd());
        return this.getMetricQueryService().getThermodynamic(metrics.getName(), metrics.getId(), StepToDownsampling.transform((Step)duration.getStep()), startTimeBucket, endTimeBucket);
    }
}

