/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.skywalking.oap.query.graphql.type.TimeInfo;
import org.apache.skywalking.oap.server.core.query.MetadataQueryService;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.ClusterBrief;
import org.apache.skywalking.oap.server.core.query.type.Database;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.EndpointInfo;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class MetadataQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private MetadataQueryService metadataQueryService;

    public MetadataQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private MetadataQueryService getMetadataQueryService() {
        if (this.metadataQueryService == null) {
            this.metadataQueryService = (MetadataQueryService)this.moduleManager.find("core").provider().getService(MetadataQueryService.class);
        }
        return this.metadataQueryService;
    }

    @Deprecated
    public ClusterBrief getGlobalBrief(Duration duration) throws IOException, ParseException {
        return new ClusterBrief();
    }

    public List<Service> getAllServices(Duration duration) throws IOException, ParseException {
        return this.getMetadataQueryService().getAllServices(duration.getStartTimestamp(), duration.getEndTimestamp());
    }

    public List<Service> getAllBrowserServices(Duration duration) throws IOException, ParseException {
        return this.getMetadataQueryService().getAllBrowserServices(duration.getStartTimestamp(), duration.getEndTimestamp());
    }

    public List<Service> searchServices(Duration duration, String keyword) throws IOException, ParseException {
        return this.getMetadataQueryService().searchServices(duration.getStartTimestamp(), duration.getEndTimestamp(), keyword);
    }

    public Service searchService(String serviceCode) throws IOException {
        return this.getMetadataQueryService().searchService(serviceCode);
    }

    public List<ServiceInstance> getServiceInstances(Duration duration, String serviceId) throws IOException, ParseException {
        return this.getMetadataQueryService().getServiceInstances(duration.getStartTimestamp(), duration.getEndTimestamp(), serviceId);
    }

    public List<Endpoint> searchEndpoint(String keyword, String serviceId, int limit) throws IOException {
        return this.getMetadataQueryService().searchEndpoint(keyword, serviceId, limit);
    }

    public EndpointInfo getEndpointInfo(String endpointId) throws IOException {
        return this.getMetadataQueryService().getEndpointInfo(endpointId);
    }

    public List<Database> getAllDatabases(Duration duration) throws IOException {
        return this.getMetadataQueryService().getAllDatabases();
    }

    public TimeInfo getTimeInfo() {
        TimeInfo timeInfo = new TimeInfo();
        SimpleDateFormat timezoneFormat = new SimpleDateFormat("ZZZZZZ");
        Date date = new Date();
        timeInfo.setCurrentTimestamp(date.getTime());
        timeInfo.setTimezone(timezoneFormat.format(date));
        return timeInfo;
    }
}

