/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.AggregationQueryService;
import org.apache.skywalking.oap.server.core.query.MetricDefinition;
import org.apache.skywalking.oap.server.core.query.MetricsMetadataQueryService;
import org.apache.skywalking.oap.server.core.query.MetricsQueryService;
import org.apache.skywalking.oap.server.core.query.TopNRecordsQueryService;
import org.apache.skywalking.oap.server.core.query.enumeration.MetricsType;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class MetricsQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private MetricsQueryService metricsQueryService;
    private AggregationQueryService queryService;
    private TopNRecordsQueryService topNRecordsQueryService;
    private MetricsMetadataQueryService metricsMetadataQueryService;

    public MetricsQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private MetricsMetadataQueryService getMetricsMetadataQueryService() {
        if (this.metricsMetadataQueryService == null) {
            this.metricsMetadataQueryService = (MetricsMetadataQueryService)this.moduleManager.find("core").provider().getService(MetricsMetadataQueryService.class);
        }
        return this.metricsMetadataQueryService;
    }

    private AggregationQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (AggregationQueryService)this.moduleManager.find("core").provider().getService(AggregationQueryService.class);
        }
        return this.queryService;
    }

    private TopNRecordsQueryService getTopNRecordsQueryService() {
        if (this.topNRecordsQueryService == null) {
            this.topNRecordsQueryService = (TopNRecordsQueryService)this.moduleManager.find("core").provider().getService(TopNRecordsQueryService.class);
        }
        return this.topNRecordsQueryService;
    }

    private MetricsQueryService getMetricsQueryService() {
        if (this.metricsQueryService == null) {
            this.metricsQueryService = (MetricsQueryService)this.moduleManager.find("core").provider().getService(MetricsQueryService.class);
        }
        return this.metricsQueryService;
    }

    public MetricsType typeOfMetrics(String name) throws IOException {
        return this.getMetricsMetadataQueryService().typeOfMetrics(name);
    }

    public List<MetricDefinition> listMetrics(String regex) {
        return this.getMetricsMetadataQueryService().listMetrics(regex);
    }

    public long readMetricsValue(MetricsCondition condition, Duration duration) throws IOException {
        if (MetricsType.UNKNOWN.equals((Object)this.typeOfMetrics(condition.getName())) || !condition.getEntity().isValid()) {
            return 0L;
        }
        return this.getMetricsQueryService().readMetricsValue(condition, duration);
    }

    public MetricsValues readMetricsValues(MetricsCondition condition, Duration duration) throws IOException {
        if (MetricsType.UNKNOWN.equals((Object)this.typeOfMetrics(condition.getName())) || !condition.getEntity().isValid()) {
            List pointOfTimes = duration.assembleDurationPoints();
            MetricsValues values = new MetricsValues();
            pointOfTimes.forEach(pointOfTime -> {
                String id = pointOfTime.id(condition.getEntity().isValid() ? condition.getEntity().buildId() : "ILLEGAL_ENTITY");
                KVInt kvInt = new KVInt();
                kvInt.setId(id);
                kvInt.setValue(0L);
                values.getValues().addKVInt(kvInt);
            });
            return values;
        }
        return this.getMetricsQueryService().readMetricsValues(condition, duration);
    }

    public List<SelectedRecord> sortMetrics(TopNCondition condition, Duration duration) throws IOException {
        if (MetricsType.UNKNOWN.equals((Object)this.typeOfMetrics(condition.getName()))) {
            return Collections.emptyList();
        }
        return this.getQueryService().sortMetrics(condition, duration);
    }

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, List<String> labels, Duration duration) throws IOException {
        if (MetricsType.UNKNOWN.equals((Object)this.typeOfMetrics(condition.getName())) || !condition.getEntity().isValid()) {
            List pointOfTimes = duration.assembleDurationPoints();
            ArrayList<MetricsValues> labeledValues = new ArrayList<MetricsValues>(labels.size());
            labels.forEach(label -> {
                MetricsValues values = new MetricsValues();
                pointOfTimes.forEach(pointOfTime -> {
                    String id = pointOfTime.id(condition.getEntity().isValid() ? condition.getEntity().buildId() : "ILLEGAL_ENTITY");
                    KVInt kvInt = new KVInt();
                    kvInt.setId(id);
                    kvInt.setValue(0L);
                    values.getValues().addKVInt(kvInt);
                });
                values.setLabel(label);
                labeledValues.add(values);
            });
            return labeledValues;
        }
        return this.getMetricsQueryService().readLabeledMetricsValues(condition, labels, duration);
    }

    public HeatMap readHeatMap(MetricsCondition condition, Duration duration) throws IOException {
        if (MetricsType.UNKNOWN.equals((Object)this.typeOfMetrics(condition.getName())) || !condition.getEntity().isValid()) {
            DataTable emptyData = new DataTable();
            emptyData.put("0", Long.valueOf(0L));
            String rawdata = emptyData.toStorageData();
            HeatMap heatMap = new HeatMap();
            List pointOfTimes = duration.assembleDurationPoints();
            pointOfTimes.forEach(pointOfTime -> {
                String id = pointOfTime.id(condition.getEntity().isValid() ? condition.getEntity().buildId() : "ILLEGAL_ENTITY");
                heatMap.buildColumn(id, rawdata, 0);
            });
            return heatMap;
        }
        return this.getMetricsQueryService().readHeatMap(condition, duration);
    }

    public List<SelectedRecord> readSampledRecords(TopNCondition condition, Duration duration) throws IOException {
        if (MetricsType.UNKNOWN.equals((Object)this.typeOfMetrics(condition.getName()))) {
            return Collections.emptyList();
        }
        return this.getTopNRecordsQueryService().readSampledRecords(condition, duration);
    }
}

