/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.server.jetty.JettyJsonHandler;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLQueryHandler
extends JettyJsonHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLQueryHandler.class);
    private static final String QUERY = "query";
    private static final String VARIABLES = "variables";
    private static final String DATA = "data";
    private static final String ERRORS = "errors";
    private static final String MESSAGE = "message";
    private final Gson gson = new Gson();
    private final Type mapOfStringObjectType = new TypeToken<Map<String, Object>>(){}.getType();
    private final String path;
    private final GraphQL graphQL;

    public String pathSpec() {
        return this.path;
    }

    protected JsonElement doPost(HttpServletRequest req) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream()));
        StringBuilder request = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            request.append(line);
        }
        JsonObject requestJson = (JsonObject)this.gson.fromJson(request.toString(), JsonObject.class);
        return this.execute(requestJson.get(QUERY).getAsString(), (Map)this.gson.fromJson(requestJson.get(VARIABLES), this.mapOfStringObjectType));
    }

    private JsonObject execute(String request, Map<String, Object> variables) {
        try {
            ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(request).variables(variables).build();
            ExecutionResult executionResult = this.graphQL.execute(executionInput);
            LOGGER.debug("Execution result is {}", (Object)executionResult);
            Object data = executionResult.getData();
            List errors = executionResult.getErrors();
            JsonObject jsonObject = new JsonObject();
            if (data != null) {
                jsonObject.add(DATA, (JsonElement)this.gson.fromJson(this.gson.toJson(data), JsonObject.class));
            }
            if (CollectionUtils.isNotEmpty((List)errors)) {
                JsonArray errorArray = new JsonArray();
                errors.forEach(error -> {
                    JsonObject errorJson = new JsonObject();
                    errorJson.addProperty(MESSAGE, error.getMessage());
                    errorArray.add((JsonElement)errorJson);
                });
                jsonObject.add(ERRORS, (JsonElement)errorArray);
            }
            return jsonObject;
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            JsonObject jsonObject = new JsonObject();
            JsonArray errorArray = new JsonArray();
            JsonObject errorJson = new JsonObject();
            errorJson.addProperty(MESSAGE, e.getMessage());
            errorArray.add((JsonElement)errorJson);
            jsonObject.add(ERRORS, (JsonElement)errorArray);
            return jsonObject;
        }
    }

    @Generated
    public GraphQLQueryHandler(String path, GraphQL graphQL) {
        this.path = path;
        this.graphQL = graphQL;
    }
}

