/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.query.LogQueryService;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.LogQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class LogQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private LogQueryService logQueryService;

    public LogQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private LogQueryService getQueryService() {
        if (this.logQueryService == null) {
            this.logQueryService = (LogQueryService)this.moduleManager.find("core").provider().getService(LogQueryService.class);
        }
        return this.logQueryService;
    }

    public boolean supportQueryLogsByKeywords() {
        return this.getQueryService().supportQueryLogsByKeywords();
    }

    public Logs queryLogs(LogQueryCondition condition) throws IOException {
        if (Objects.isNull(condition.getQueryDuration()) && Objects.isNull(condition.getRelatedTrace())) {
            throw new UnexpectedException("The condition must contains either queryDuration or relatedTrace.");
        }
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(condition.getQueryDuration())) {
            startSecondTB = condition.getQueryDuration().getStartTimeBucketInSec();
            endSecondTB = condition.getQueryDuration().getEndTimeBucketInSec();
        }
        Order queryOrder = Objects.isNull(condition.getQueryOrder()) ? Order.DES : condition.getQueryOrder();
        return this.getQueryService().queryLogs(condition.getServiceId(), condition.getServiceInstanceId(), condition.getEndpointId(), condition.getRelatedTrace(), condition.getPaging(), queryOrder, startSecondTB, endSecondTB, condition.getTags(), condition.getKeywordsOfContent(), condition.getExcludingKeywordsOfContent());
    }
}

