/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.query.TopologyQueryService;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.EndpointTopology;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstanceTopology;
import org.apache.skywalking.oap.server.core.query.type.Topology;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class TopologyQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private TopologyQueryService queryService;

    public TopologyQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private TopologyQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (TopologyQueryService)this.moduleManager.find("core").provider().getService(TopologyQueryService.class);
        }
        return this.queryService;
    }

    public Topology getGlobalTopology(Duration duration) throws IOException {
        return this.getQueryService().getGlobalTopology(duration.getStartTimeBucket(), duration.getEndTimeBucket());
    }

    public Topology getServiceTopology(String serviceId, Duration duration) throws IOException {
        ArrayList<String> selectedServiceList = new ArrayList<String>(1);
        selectedServiceList.add(serviceId);
        return this.getServicesTopology(selectedServiceList, duration);
    }

    public Topology getServicesTopology(List<String> serviceIds, Duration duration) throws IOException {
        return this.getQueryService().getServiceTopology(duration.getStartTimeBucket(), duration.getEndTimeBucket(), serviceIds);
    }

    public ServiceInstanceTopology getServiceInstanceTopology(String clientServiceId, String serverServiceId, Duration duration) throws IOException {
        return this.getQueryService().getServiceInstanceTopology(clientServiceId, serverServiceId, duration.getStartTimeBucket(), duration.getEndTimeBucket());
    }

    @Deprecated
    public Topology getEndpointTopology(String endpointId, Duration duration) throws IOException {
        return this.getQueryService().getEndpointTopology(duration.getStartTimeBucket(), duration.getEndTimeBucket(), endpointId);
    }

    public EndpointTopology getEndpointDependencies(String endpointId, Duration duration) throws IOException {
        return this.getQueryService().getEndpointDependencies(duration.getStartTimeBucket(), duration.getEndTimeBucket(), endpointId);
    }
}

