/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.server.core.profiling.ebpf.EBPFProfilingQueryService;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.EBPFProfilingTaskCondition;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzeTimeRange;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingSchedule;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTask;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class EBPFProcessProfilingQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private EBPFProfilingQueryService queryService;

    public EBPFProcessProfilingQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public EBPFProfilingQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (EBPFProfilingQueryService)this.moduleManager.find("core").provider().getService(EBPFProfilingQueryService.class);
        }
        return this.queryService;
    }

    public List<EBPFProfilingTask> queryEBPFProfilingTasks(EBPFProfilingTaskCondition query) throws IOException {
        if (query == null || StringUtil.isEmpty((String)query.getServiceId()) && StringUtil.isEmpty((String)query.getInstanceId()) && StringUtil.isEmpty((String)query.getProcessId())) {
            throw new IllegalArgumentException("please provide the task condition");
        }
        return this.getQueryService().queryEBPFProfilingTasks(query);
    }

    public List<EBPFProfilingSchedule> queryEBPFProfilingSchedules(String taskId, Duration duration) throws IOException {
        return this.getQueryService().queryEBPFProfilingSchedules(taskId, duration);
    }

    public EBPFProfilingAnalyzation getEBPFProfilingAnalyzation(String taskId, List<EBPFProfilingAnalyzeTimeRange> timeRanges) throws IOException {
        return this.getQueryService().getEBPFProfilingAnalyzation(taskId, timeRanges);
    }
}

