/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.oap.query.graphql.type.TimeInfo;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.MetadataQueryService;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.EndpointInfo;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class MetadataQueryV2
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private MetadataQueryService metadataQueryService;

    public MetadataQueryV2(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private MetadataQueryService getMetadataQueryService() {
        if (this.metadataQueryService == null) {
            this.metadataQueryService = (MetadataQueryService)this.moduleManager.find("core").provider().getService(MetadataQueryService.class);
        }
        return this.metadataQueryService;
    }

    public Set<String> listLayers() throws IOException {
        return this.getMetadataQueryService().listLayers();
    }

    public List<Service> listServices(String layer) throws IOException {
        return this.getMetadataQueryService().listServices(layer, null);
    }

    public Service findService(String serviceName) throws IOException {
        return this.getMetadataQueryService().getService(IDManager.ServiceID.buildId((String)serviceName, (boolean)true));
    }

    public Service getService(String serviceId) throws IOException {
        return this.getMetadataQueryService().getService(serviceId);
    }

    public List<ServiceInstance> listInstances(Duration duration, String serviceId) throws IOException {
        return this.getMetadataQueryService().listInstances(duration.getStartTimestamp(), duration.getEndTimestamp(), serviceId);
    }

    public ServiceInstance getInstance(String instanceId) throws IOException {
        return this.getMetadataQueryService().getInstance(instanceId);
    }

    public List<Endpoint> findEndpoint(String keyword, String serviceId, int limit) throws IOException {
        return this.getMetadataQueryService().findEndpoint(keyword, serviceId, limit);
    }

    public EndpointInfo getEndpointInfo(String endpointId) throws IOException {
        return this.getMetadataQueryService().getEndpointInfo(endpointId);
    }

    public List<Process> listProcesses(String serviceId, String instanceId) throws IOException {
        return this.getMetadataQueryService().listProcesses(serviceId, instanceId);
    }

    public Process getProcess(String processId) throws IOException {
        return this.getMetadataQueryService().getProcess(processId);
    }

    public TimeInfo getTimeInfo() {
        TimeInfo timeInfo = new TimeInfo();
        SimpleDateFormat timezoneFormat = new SimpleDateFormat("ZZZZZZ");
        Date date = new Date();
        timeInfo.setCurrentTimestamp(date.getTime());
        timeInfo.setTimezone(timezoneFormat.format(date));
        return timeInfo;
    }
}

