/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileTaskQueryService;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.query.type.ProfileAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.ProfileAnalyzeTimeRange;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLog;
import org.apache.skywalking.oap.server.core.query.type.ProfiledSegment;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class ProfileQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private ProfileTaskQueryService profileTaskQueryService;

    public ProfileQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private ProfileTaskQueryService getProfileTaskQueryService() {
        if (this.profileTaskQueryService == null) {
            this.profileTaskQueryService = (ProfileTaskQueryService)this.moduleManager.find("core").provider().getService(ProfileTaskQueryService.class);
        }
        return this.profileTaskQueryService;
    }

    public List<ProfileTask> getProfileTaskList(String serviceId, String endpointName) throws IOException {
        return this.getProfileTaskQueryService().getTaskList(serviceId, endpointName);
    }

    public List<ProfileTaskLog> getProfileTaskLogs(String taskID) throws IOException {
        return this.getProfileTaskQueryService().getProfileTaskLogs(taskID);
    }

    public List<BasicTrace> getProfileTaskSegmentList(String taskID) throws IOException {
        return this.getProfileTaskQueryService().getTaskTraces(taskID);
    }

    public ProfiledSegment getProfiledSegment(String segmentId) throws IOException {
        return this.getProfileTaskQueryService().getProfiledSegment(segmentId);
    }

    public ProfileAnalyzation getProfileAnalyze(String segmentId, List<ProfileAnalyzeTimeRange> timeRanges) throws IOException {
        return this.getProfileTaskQueryService().getProfileAnalyze(segmentId, timeRanges);
    }
}

