/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import graphql.kickstart.tools.GraphQLQueryResolver;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.query.graphql.resolver.MetadataQueryV2;
import org.apache.skywalking.oap.query.graphql.type.InternalLog;
import org.apache.skywalking.oap.query.graphql.type.LogAdapter;
import org.apache.skywalking.oap.query.graphql.type.OndemandContainergQueryCondition;
import org.apache.skywalking.oap.query.graphql.type.OndemandLogQueryCondition;
import org.apache.skywalking.oap.query.graphql.type.PodContainers;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Attribute;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OndemandLogQuery
implements GraphQLQueryResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OndemandLogQuery.class);
    private final Gson gson = new Gson();
    private final Type responseType = new TypeToken<Map<String, Object>>(){}.getType();
    private CoreV1Api kApi;
    private final MetadataQueryV2 metadataQuery;

    public PodContainers listContainers(OndemandContainergQueryCondition condition) throws IOException {
        ServiceInstance instance = this.metadataQuery.getInstance(condition.getServiceInstanceId());
        Map<String, String> attributesMap = this.convertInstancePropertiesToMap(instance);
        String ns = attributesMap.get("namespace");
        String pod = attributesMap.get("pod");
        return this.listContainers(ns, pod);
    }

    public Logs ondemandPodLogs(OndemandLogQueryCondition condition) throws IOException {
        ServiceInstance instance = this.metadataQuery.getInstance(condition.getServiceInstanceId());
        Map<String, String> attributesMap = this.convertInstancePropertiesToMap(instance);
        String ns = attributesMap.get("namespace");
        String pod = attributesMap.get("pod");
        return this.ondemandPodLogs(ns, pod, condition);
    }

    protected Map<String, String> convertInstancePropertiesToMap(ServiceInstance instance) {
        if (instance == null) {
            return Collections.emptyMap();
        }
        List attributes = instance.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, String> attributesMap = attributes.stream().collect(Collectors.toMap(Attribute::getName, Attribute::getValue));
        if (!attributesMap.containsKey("namespace") || !attributesMap.containsKey("pod")) {
            return Collections.emptyMap();
        }
        return attributesMap;
    }

    public PodContainers listContainers(String namespace, String podName) throws IOException {
        try {
            if (Strings.isNullOrEmpty((String)namespace) || Strings.isNullOrEmpty((String)podName)) {
                return new PodContainers().setErrorReason("namespace and podName can't be null or empty");
            }
            V1Pod pod = this.kApi().readNamespacedPod(podName, namespace, null);
            V1PodSpec spec = pod.getSpec();
            if (Objects.isNull(spec)) {
                return new PodContainers().setErrorReason("No pod spec can be found");
            }
            List<String> containers = spec.getContainers().stream().map(V1Container::getName).collect(Collectors.toList());
            if (Objects.nonNull(spec.getInitContainers())) {
                List init = spec.getInitContainers().stream().map(V1Container::getName).collect(Collectors.toList());
                containers.addAll(init);
            }
            return new PodContainers().setContainers(containers);
        }
        catch (ApiException e) {
            log.error("Failed to list containers from Kubernetes, {}", (Object)e.getResponseBody(), (Object)e);
            if (!Strings.isNullOrEmpty((String)e.getResponseBody())) {
                Map responseBody = (Map)this.gson.fromJson(e.getResponseBody(), this.responseType);
                String message = ((Object)responseBody.getOrDefault("message", e.getCode())).toString();
                return new PodContainers().setErrorReason(message);
            }
            return new PodContainers().setErrorReason(e.getMessage() + ": " + e.getCode());
        }
    }

    public Logs ondemandPodLogs(String namespace, String podName, OndemandLogQueryCondition condition) throws IOException {
        if (Strings.isNullOrEmpty((String)namespace) || Strings.isNullOrEmpty((String)podName)) {
            return new Logs().setErrorReason("namespace and podName can't be null or empty");
        }
        try {
            V1Pod pod = this.kApi().readNamespacedPod(podName, namespace, null);
            V1ObjectMeta podMetadata = pod.getMetadata();
            if (Objects.isNull(podMetadata)) {
                return new Logs().setErrorReason("No pod metadata can be found");
            }
            V1PodSpec spec = pod.getSpec();
            if (Objects.isNull(spec)) {
                return new Logs().setErrorReason("No pod spec can be found");
            }
            Duration duration = new Duration();
            duration.setStart(condition.getDuration().getStart());
            duration.setEnd(condition.getDuration().getEnd());
            duration.setStep(condition.getDuration().getStep());
            long since = duration.getStartTimestamp() / 1000L;
            String container = condition.getContainer();
            String podLog = this.kApi().readNamespacedPodLog(podMetadata.getName(), podMetadata.getNamespace(), container, Boolean.valueOf(false), null, null, null, null, Integer.valueOf((int)since), null, Boolean.valueOf(true));
            List<InternalLog> logs = Splitter.on((String)"\n").omitEmptyStrings().splitToList((CharSequence)Strings.nullToEmpty((String)podLog)).stream().filter(StringUtil::isNotBlank).map(it -> InternalLog.builder().line((String)it).container(container).build()).collect(Collectors.toList());
            List<Log> filtered = this.filter(condition, logs);
            List limited = filtered.stream().limit(10000L).collect(Collectors.toList());
            Logs result = new Logs();
            result.getLogs().addAll(limited);
            return result;
        }
        catch (ApiException e) {
            log.error("Failed to fetch logs from Kubernetes, {}", (Object)e.getResponseBody(), (Object)e);
            if (!Strings.isNullOrEmpty((String)e.getResponseBody())) {
                Map responseBody = (Map)this.gson.fromJson(e.getResponseBody(), this.responseType);
                String message = ((Object)responseBody.getOrDefault("message", e.getCode())).toString();
                return new Logs().setErrorReason(message);
            }
            return new Logs().setErrorReason(e.getMessage() + ": " + e.getCode());
        }
    }

    private List<Log> filter(OndemandLogQueryCondition request, List<InternalLog> logs) {
        Duration duration = new Duration();
        duration.setStart(request.getDuration().getStart());
        duration.setEnd(request.getDuration().getEnd());
        duration.setStep(request.getDuration().getStep());
        long since = duration.getStartTimestamp() / 1000L;
        long to = duration.getEndTimestamp() / 1000L;
        List<String> inclusions = request.getKeywordsOfContent();
        com.google.common.base.Predicate inclusivePredicate = l -> inclusions.isEmpty() || inclusions.stream().anyMatch(k -> l.getContent().matches((String)k));
        List<String> exclusions = request.getExcludingKeywordsOfContent();
        com.google.common.base.Predicate exclusivePredicate = l -> exclusions.isEmpty() || exclusions.stream().noneMatch(k -> l.getContent().matches((String)k));
        return logs.stream().map(LogAdapter::new).map(LogAdapter::adapt).filter((Predicate<Log>)inclusivePredicate).filter((Predicate<Log>)exclusivePredicate).filter(it -> it.getTimestamp() >= since).filter(it -> it.getTimestamp() <= to).sorted(Comparator.comparing(Log::getTimestamp)).collect(Collectors.toList());
    }

    private CoreV1Api kApi() throws IOException {
        if (this.kApi == null) {
            Configuration.setDefaultApiClient((ApiClient)Config.defaultClient().setReadTimeout(30000).setWriteTimeout(30000).setConnectTimeout(303000));
            this.kApi = new CoreV1Api();
        }
        return this.kApi;
    }

    @Generated
    public OndemandLogQuery(MetadataQueryV2 metadataQuery) {
        this.metadataQuery = metadataQuery;
    }
}

