/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.google.common.base.Strings;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.AlarmQueryService;
import org.apache.skywalking.oap.server.core.query.EventQueryService;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.type.AlarmTrend;
import org.apache.skywalking.oap.server.core.query.type.Alarms;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.query.type.event.Event;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.Source;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class AlarmQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private AlarmQueryService queryService;
    private EventQueryService eventQueryService;

    public AlarmQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private AlarmQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (AlarmQueryService)this.moduleManager.find("core").provider().getService(AlarmQueryService.class);
        }
        return this.queryService;
    }

    private EventQueryService getEventQueryService() {
        if (this.eventQueryService == null) {
            this.eventQueryService = (EventQueryService)this.moduleManager.find("core").provider().getService(EventQueryService.class);
        }
        return this.eventQueryService;
    }

    public AlarmTrend getAlarmTrend(Duration duration) {
        return new AlarmTrend();
    }

    public Alarms getAlarm(Duration duration, Scope scope, String keyword, Pagination paging, List<Tag> tags, DataFetchingEnvironment env) throws Exception {
        Integer scopeId = null;
        if (scope != null) {
            scopeId = scope.getScopeId();
        }
        EventQueryCondition.EventQueryConditionBuilder conditionPrototype = EventQueryCondition.builder().paging(new Pagination(1, 100));
        if (Objects.nonNull(duration)) {
            conditionPrototype.time(duration);
        }
        Alarms alarms = this.getQueryService().getAlarm(scopeId, keyword, paging, duration, tags);
        boolean selectEvents = env.getSelectionSet().contains("**/events/**");
        if (selectEvents) {
            return this.findRelevantEvents(alarms, conditionPrototype);
        }
        return alarms;
    }

    private Alarms findRelevantEvents(Alarms alarms, EventQueryCondition.EventQueryConditionBuilder conditionPrototype) throws Exception {
        if (CollectionUtils.isEmpty((List)alarms.getMsgs())) {
            return alarms;
        }
        List allConditions = alarms.getMsgs().stream().flatMap(m -> this.buildEventSources((AlarmMessage)m).stream().map(arg_0 -> ((EventQueryCondition.EventQueryConditionBuilder)conditionPrototype).source(arg_0))).map(EventQueryCondition.EventQueryConditionBuilder::build).collect(Collectors.toList());
        List events = this.getEventQueryService().queryEvents(allConditions).getEvents();
        Map<String, List<Event>> eventsKeyedBySourceId = events.stream().filter(it -> !Strings.isNullOrEmpty((String)this.buildSourceID((Event)it))).collect(Collectors.groupingBy(this::buildSourceID));
        alarms.getMsgs().forEach(a -> {
            if (CollectionUtils.isNotEmpty((List)((List)eventsKeyedBySourceId.get(a.getId())))) {
                a.getEvents().addAll((Collection)eventsKeyedBySourceId.get(a.getId()));
            }
            if (CollectionUtils.isNotEmpty((List)((List)eventsKeyedBySourceId.get(a.getId1())))) {
                a.getEvents().addAll((Collection)eventsKeyedBySourceId.get(a.getId1()));
            }
        });
        return alarms;
    }

    private List<Source> buildEventSources(AlarmMessage msg) {
        ArrayList<Source> sources = new ArrayList<Source>(2);
        Source.SourceBuilder sourcePrototype = Source.builder();
        switch (msg.getScopeId()) {
            case 4: {
                IDManager.ServiceID.ServiceIDDefinition destServiceIdDef = IDManager.ServiceID.analysisId((String)msg.getId1());
                sources.add(sourcePrototype.service(destServiceIdDef.getName()).build());
            }
            case 1: {
                IDManager.ServiceID.ServiceIDDefinition sourceServiceIdDef = IDManager.ServiceID.analysisId((String)msg.getId());
                sources.add(sourcePrototype.service(sourceServiceIdDef.getName()).build());
                break;
            }
            case 5: {
                IDManager.ServiceInstanceID.InstanceIDDefinition destInstanceIdDef = IDManager.ServiceInstanceID.analysisId((String)msg.getId1());
                String destServiceName = IDManager.ServiceID.analysisId((String)destInstanceIdDef.getServiceId()).getName();
                sources.add(sourcePrototype.service(destServiceName).serviceInstance(destInstanceIdDef.getName()).build());
            }
            case 2: {
                IDManager.ServiceInstanceID.InstanceIDDefinition sourceInstanceIdDef = IDManager.ServiceInstanceID.analysisId((String)msg.getId());
                String serviceName = IDManager.ServiceID.analysisId((String)sourceInstanceIdDef.getServiceId()).getName();
                sources.add(sourcePrototype.serviceInstance(sourceInstanceIdDef.getName()).service(serviceName).build());
                break;
            }
            case 6: {
                IDManager.EndpointID.EndpointIDDefinition destEndpointIDDef = IDManager.EndpointID.analysisId((String)msg.getId1());
                String destEndpointServiceName = IDManager.ServiceID.analysisId((String)destEndpointIDDef.getServiceId()).getName();
                sources.add(sourcePrototype.service(destEndpointServiceName).build());
            }
            case 3: {
                IDManager.EndpointID.EndpointIDDefinition endpointIDDef = IDManager.EndpointID.analysisId((String)msg.getId());
                String endpointServiceName = IDManager.ServiceID.analysisId((String)endpointIDDef.getServiceId()).getName();
                sources.add(sourcePrototype.service(endpointServiceName).build());
            }
        }
        return sources;
    }

    protected String buildSourceID(Event event) {
        Source source = event.getSource();
        if (Objects.isNull(source)) {
            return "";
        }
        String service = source.getService();
        String serviceId = IDManager.ServiceID.buildId((String)service, (boolean)true);
        if (Strings.isNullOrEmpty((String)service)) {
            return "";
        }
        String instance = source.getServiceInstance();
        if (Strings.isNullOrEmpty((String)instance)) {
            return serviceId;
        }
        return IDManager.ServiceInstanceID.buildId((String)serviceId, (String)instance);
    }
}

