/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.text.DecimalFormat;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.mqe.rt.exception.ParseErrorListener;
import org.apache.skywalking.mqe.rt.grammar.MQELexer;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.mqe.rt.type.ExpressionResult;
import org.apache.skywalking.mqe.rt.type.ExpressionResultType;
import org.apache.skywalking.oap.query.graphql.mqe.rt.MQEVisitor;
import org.apache.skywalking.oap.query.graphql.resolver.MetricsQuery;
import org.apache.skywalking.oap.query.graphql.resolver.RecordsQuery;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.Entity;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class MetricsExpressionQuery
implements GraphQLQueryResolver {
    private final MetricsQuery metricsQuery;
    private final RecordsQuery recordsQuery;
    private final DecimalFormat valueFormat = new DecimalFormat();

    public MetricsExpressionQuery(ModuleManager moduleManager) {
        this.metricsQuery = new MetricsQuery(moduleManager);
        this.recordsQuery = new RecordsQuery(moduleManager);
        this.valueFormat.setGroupingUsed(false);
    }

    public ExpressionResult execExpression(String expression, Entity entity, Duration duration) {
        MQEParser.ExpressionContext tree;
        MQELexer lexer = new MQELexer((CharStream)CharStreams.fromString((String)expression));
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        MQEParser parser = new MQEParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        try {
            tree = parser.expression();
        }
        catch (ParseCancellationException e) {
            ExpressionResult errorResult = new ExpressionResult();
            errorResult.setType(ExpressionResultType.UNKNOWN);
            errorResult.setError(e.getMessage());
            return errorResult;
        }
        MQEVisitor visitor = new MQEVisitor(this.metricsQuery, this.recordsQuery, entity, duration);
        ExpressionResult parseResult = (ExpressionResult)visitor.visit((ParseTree)tree);
        parseResult.getResults().forEach(mqeValues -> mqeValues.getValues().forEach(mqeValue -> {
            if (!mqeValue.isEmptyValue()) {
                mqeValue.setValue(this.valueFormat.format(mqeValue.getDoubleValue()));
            }
        }));
        return parseResult;
    }
}

