/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import com.google.protobuf.AbstractMessageLite;
import java.io.IOException;
import java.util.List;
import org.apache.skywalking.aop.server.receiver.mesh.MeshModuleConfig;
import org.apache.skywalking.aop.server.receiver.mesh.ServiceMeshMetricDataDecorator;
import org.apache.skywalking.aop.server.receiver.mesh.TelemetryDataDispatcher;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.apm.network.servicemesh.ServiceMeshMetric;
import org.apache.skywalking.oap.server.library.buffer.BufferStream;
import org.apache.skywalking.oap.server.library.buffer.DataStreamReader;

public class MeshDataBufferFileCache
implements IConsumer<ServiceMeshMetricDataDecorator>,
DataStreamReader.CallBack<ServiceMeshMetric> {
    private MeshModuleConfig config;
    private DataCarrier<ServiceMeshMetricDataDecorator> dataCarrier;
    private BufferStream<ServiceMeshMetric> stream;

    public MeshDataBufferFileCache(MeshModuleConfig config) {
        this.config = config;
        this.dataCarrier = new DataCarrier("MeshDataBufferFileCache", 3, 1024);
    }

    void start() throws IOException {
        this.dataCarrier.consume((IConsumer)this, 1);
        BufferStream.Builder builder = new BufferStream.Builder(this.config.getBufferPath());
        builder.cleanWhenRestart(this.config.isBufferFileCleanWhenRestart());
        builder.dataFileMaxSize(this.config.getBufferDataMaxFileSize());
        builder.offsetFileMaxSize(this.config.getBufferOffsetMaxFileSize());
        builder.parser(ServiceMeshMetric.parser());
        builder.callBack((DataStreamReader.CallBack)this);
        this.stream = builder.build();
        this.stream.initialize();
    }

    public void init() {
    }

    public void in(ServiceMeshMetric metric) {
        this.dataCarrier.produce((Object)new ServiceMeshMetricDataDecorator(metric));
    }

    public void consume(List<ServiceMeshMetricDataDecorator> data) {
        for (ServiceMeshMetricDataDecorator decorator : data) {
            if (decorator.tryMetaDataRegister()) {
                TelemetryDataDispatcher.doDispatch(decorator);
                continue;
            }
            this.stream.write((AbstractMessageLite)decorator.getMetric());
        }
    }

    public void onError(List<ServiceMeshMetricDataDecorator> data, Throwable t) {
    }

    public void onExit() {
    }

    public boolean call(ServiceMeshMetric message) {
        ServiceMeshMetricDataDecorator decorator = new ServiceMeshMetricDataDecorator(message);
        if (decorator.tryMetaDataRegister()) {
            TelemetryDataDispatcher.doDispatch(decorator);
            return true;
        }
        return false;
    }
}

