/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import io.grpc.stub.StreamObserver;
import org.apache.skywalking.aop.server.receiver.mesh.TelemetryDataDispatcher;
import org.apache.skywalking.apm.network.servicemesh.MeshProbeDownstream;
import org.apache.skywalking.apm.network.servicemesh.ServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.ServiceMeshMetricServiceGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGRPCHandler
extends ServiceMeshMetricServiceGrpc.ServiceMeshMetricServiceImplBase {
    private static final Logger logger = LoggerFactory.getLogger(MeshGRPCHandler.class);

    public StreamObserver<ServiceMeshMetric> collect(final StreamObserver<MeshProbeDownstream> responseObserver) {
        return new StreamObserver<ServiceMeshMetric>(){

            public void onNext(ServiceMeshMetric metric) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received mesh metric: {}", (Object)metric);
                }
                TelemetryDataDispatcher.preProcess(metric);
            }

            public void onError(Throwable throwable) {
                logger.error(throwable.getMessage(), throwable);
                responseObserver.onCompleted();
            }

            public void onCompleted() {
                responseObserver.onNext((Object)MeshProbeDownstream.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

