/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import io.grpc.stub.StreamObserver;
import org.apache.skywalking.aop.server.receiver.mesh.TelemetryDataDispatcher;
import org.apache.skywalking.apm.network.servicemesh.MeshProbeDownstream;
import org.apache.skywalking.apm.network.servicemesh.ServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.ServiceMeshMetricServiceGrpc;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetric;
import org.apache.skywalking.oap.server.telemetry.api.MetricCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGRPCHandler
extends ServiceMeshMetricServiceGrpc.ServiceMeshMetricServiceImplBase {
    private static final Logger logger = LoggerFactory.getLogger(MeshGRPCHandler.class);
    private HistogramMetric histogram;

    public MeshGRPCHandler(ModuleManager moduleManager) {
        MetricCreator metricCreator = (MetricCreator)moduleManager.find("telemetry").provider().getService(MetricCreator.class);
        this.histogram = metricCreator.createHistogramMetric("mesh_grpc_in_latency", "The process latency of service mesh telemetry", MetricTag.EMPTY_KEY, MetricTag.EMPTY_VALUE, new double[0]);
    }

    public StreamObserver<ServiceMeshMetric> collect(final StreamObserver<MeshProbeDownstream> responseObserver) {
        return new StreamObserver<ServiceMeshMetric>(){

            public void onNext(ServiceMeshMetric metric) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received mesh metric: {}", (Object)metric);
                }
                HistogramMetric.Timer timer = MeshGRPCHandler.this.histogram.createTimer();
                try {
                    TelemetryDataDispatcher.preProcess(metric);
                }
                finally {
                    timer.finish();
                }
            }

            public void onError(Throwable throwable) {
                logger.error(throwable.getMessage(), throwable);
                responseObserver.onCompleted();
            }

            public void onCompleted() {
                responseObserver.onNext((Object)MeshProbeDownstream.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

