/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import com.google.gson.JsonObject;
import org.apache.skywalking.apm.network.servicemesh.ServiceMeshMetric;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.receiver.sharing.server.CoreRegisterLinker;

public class ServiceMeshMetricDataDecorator {
    private ServiceMeshMetric origin;
    private ServiceMeshMetric rebuiltData;
    private ServiceMeshMetric.Builder newDataBuilder;
    private int endpointId;

    public ServiceMeshMetricDataDecorator(ServiceMeshMetric origin) {
        this.origin = origin;
    }

    boolean tryMetaDataRegister() {
        int sourceServiceId = 0;
        int sourceServiceInstanceId = 0;
        int destServiceId = 0;
        int destServiceInstanceId = 0;
        boolean isRegistered = true;
        sourceServiceId = this.origin.getSourceServiceId();
        if (sourceServiceId == 0) {
            sourceServiceId = CoreRegisterLinker.getServiceInventoryRegister().getOrCreate(this.origin.getSourceServiceName(), null);
            if (sourceServiceId != 0) {
                this.getNewDataBuilder().setSourceServiceId(sourceServiceId);
            } else {
                isRegistered = false;
            }
        }
        sourceServiceInstanceId = this.origin.getSourceServiceInstanceId();
        if (sourceServiceId != 0 && sourceServiceInstanceId == 0) {
            sourceServiceInstanceId = CoreRegisterLinker.getServiceInstanceInventoryRegister().getOrCreate(sourceServiceId, this.origin.getSourceServiceInstance(), this.origin.getSourceServiceInstance(), this.origin.getEndTime(), this.getOSInfoForMesh(this.origin.getSourceServiceInstance()));
            if (sourceServiceInstanceId != 0) {
                this.getNewDataBuilder().setSourceServiceInstanceId(sourceServiceInstanceId);
            } else {
                isRegistered = false;
            }
        }
        if ((destServiceId = this.origin.getDestServiceId()) == 0) {
            destServiceId = CoreRegisterLinker.getServiceInventoryRegister().getOrCreate(this.origin.getDestServiceName(), null);
            if (destServiceId != 0) {
                this.getNewDataBuilder().setDestServiceId(destServiceId);
            } else {
                isRegistered = false;
            }
        }
        destServiceInstanceId = this.origin.getDestServiceInstanceId();
        if (destServiceId != 0 && destServiceInstanceId == 0) {
            destServiceInstanceId = CoreRegisterLinker.getServiceInstanceInventoryRegister().getOrCreate(destServiceId, this.origin.getDestServiceInstance(), this.origin.getDestServiceInstance(), this.origin.getEndTime(), this.getOSInfoForMesh(this.origin.getDestServiceInstance()));
            if (destServiceInstanceId != 0) {
                this.getNewDataBuilder().setDestServiceInstanceId(destServiceInstanceId);
            } else {
                isRegistered = false;
            }
        }
        String endpoint = this.origin.getEndpoint();
        org.apache.skywalking.apm.network.common.DetectPoint point = this.origin.getDetectPoint();
        if (org.apache.skywalking.apm.network.common.DetectPoint.client.equals((Object)point)) {
            if (sourceServiceId != 0) {
                this.endpointId = CoreRegisterLinker.getEndpointInventoryRegister().getOrCreate(sourceServiceId, endpoint, DetectPoint.fromNetworkProtocolDetectPoint((org.apache.skywalking.apm.network.common.DetectPoint)point));
            }
        } else if (destServiceId != 0) {
            this.endpointId = CoreRegisterLinker.getEndpointInventoryRegister().getOrCreate(destServiceId, endpoint, DetectPoint.fromNetworkProtocolDetectPoint((org.apache.skywalking.apm.network.common.DetectPoint)point));
        }
        if (this.endpointId == 0) {
            isRegistered = false;
        }
        return isRegistered;
    }

    public ServiceMeshMetric getMetric() {
        if (this.newDataBuilder != null) {
            if (this.rebuiltData == null) {
                this.rebuiltData = this.newDataBuilder.build();
            }
            return this.rebuiltData;
        }
        return this.origin;
    }

    public int getEndpointId() {
        return this.endpointId;
    }

    private ServiceMeshMetric.Builder getNewDataBuilder() {
        if (this.newDataBuilder == null) {
            this.newDataBuilder = this.origin.toBuilder();
        }
        return this.newDataBuilder;
    }

    private JsonObject getOSInfoForMesh(String instanceName) {
        JsonObject properties = new JsonObject();
        properties.addProperty("host_name", instanceName);
        return properties;
    }
}

