/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.skywalking.apm.util.StringFormatGroup;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointNameFormater {
    private static final Logger logger = LoggerFactory.getLogger(EndpointNameFormater.class);
    private static Map<String, StringFormatGroup> ALL_RULES = new ConcurrentHashMap<String, StringFormatGroup>();

    private static void init(String service) {
        if (ALL_RULES.containsKey(service)) {
            return;
        }
        StringFormatGroup endpointRule = new StringFormatGroup();
        Properties properties = new Properties();
        try {
            InputStream stream = ResourceUtils.class.getClassLoader().getResourceAsStream(service + "_endpoint_naming_rules.properties");
            if (stream == null) {
                logger.info("{}_endpoint_naming_rules.properties not found. Try to find global endpoint rule file.", (Object)service);
                stream = ResourceUtils.class.getClassLoader().getResourceAsStream("endpoint_naming_rules.properties");
            }
            if (stream == null) {
                logger.info("endpoint_naming_rules.properties not found. No endpoint naming setup.");
            } else {
                properties.load(stream);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    endpointRule.addRule((String)key, (String)value);
                    logger.debug("endpoint naming rule of service {} found, name[{}] and rule[{}]", new Object[]{service, key, value});
                }));
            }
        }
        catch (IOException e) {
            logger.info("{}_endpoint_rules.properties not found. No endpoint naming setup.", (Object)service);
        }
        ALL_RULES.put(service, endpointRule);
        logger.debug("endpoint naming rules of service {} added. {}", (Object)service, (Object)endpointRule);
    }

    public static StringFormatGroup.FormatResult format(String service, String endpointName) {
        EndpointNameFormater.init(service);
        return ALL_RULES.get(service).format(endpointName);
    }
}

