/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.apache.skywalking.aop.server.receiver.mesh.EndpointNameFormater;
import org.apache.skywalking.aop.server.receiver.mesh.MeshDataBufferFileCache;
import org.apache.skywalking.aop.server.receiver.mesh.ServiceMeshMetricDataDecorator;
import org.apache.skywalking.apm.network.common.DetectPoint;
import org.apache.skywalking.apm.network.servicemesh.Protocol;
import org.apache.skywalking.apm.network.servicemesh.ServiceMeshMetric;
import org.apache.skywalking.apm.util.StringFormatGroup;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.core.source.All;
import org.apache.skywalking.oap.server.core.source.Endpoint;
import org.apache.skywalking.oap.server.core.source.RequestType;
import org.apache.skywalking.oap.server.core.source.Service;
import org.apache.skywalking.oap.server.core.source.ServiceInstance;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceRelation;
import org.apache.skywalking.oap.server.core.source.ServiceRelation;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryDataDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(TelemetryDataDispatcher.class);
    private static MeshDataBufferFileCache CACHE;
    private static ServiceInventoryCache SERVICE_CACHE;
    private static ServiceInstanceInventoryCache SERVICE_INSTANCE_CACHE;
    private static SourceReceiver SOURCE_RECEIVER;
    private static IServiceInstanceInventoryRegister SERVICE_INSTANCE_INVENTORY_REGISTER;
    private static IServiceInventoryRegister SERVICE_INVENTORY_REGISTER;

    private TelemetryDataDispatcher() {
    }

    public static void setCache(MeshDataBufferFileCache cache, ModuleManager moduleManager) {
        CACHE = cache;
        SERVICE_CACHE = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        SERVICE_INSTANCE_CACHE = (ServiceInstanceInventoryCache)moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
        SOURCE_RECEIVER = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        SERVICE_INSTANCE_INVENTORY_REGISTER = (IServiceInstanceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInstanceInventoryRegister.class);
        SERVICE_INVENTORY_REGISTER = (IServiceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInventoryRegister.class);
    }

    public static void preProcess(ServiceMeshMetric data) {
        ServiceMeshMetricDataDecorator decorator;
        String endpointName;
        String service = data.getDestServiceId() == 0 ? data.getDestServiceName() : SERVICE_CACHE.get(data.getDestServiceId()).getName();
        StringFormatGroup.FormatResult formatResult = EndpointNameFormater.format(service, endpointName = data.getEndpoint());
        if (formatResult.isMatch()) {
            data = data.toBuilder().setEndpoint(formatResult.getName()).build();
        }
        if (logger.isDebugEnabled() && formatResult.isMatch()) {
            logger.debug("Endpoint {} is renamed to {}", (Object)endpointName, (Object)data.getEndpoint());
        }
        if ((decorator = new ServiceMeshMetricDataDecorator(data)).tryMetaDataRegister()) {
            TelemetryDataDispatcher.doDispatch(decorator);
        } else {
            CACHE.in(data);
        }
    }

    static void doDispatch(ServiceMeshMetricDataDecorator decorator) {
        int sourceServiceId;
        ServiceMeshMetric metrics = decorator.getMetric();
        long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)metrics.getStartTime());
        TelemetryDataDispatcher.heartbeat(decorator, minuteTimeBucket);
        if (DetectPoint.server.equals((Object)metrics.getDetectPoint())) {
            TelemetryDataDispatcher.toAll(decorator, minuteTimeBucket);
            TelemetryDataDispatcher.toService(decorator, minuteTimeBucket);
            TelemetryDataDispatcher.toServiceInstance(decorator, minuteTimeBucket);
            TelemetryDataDispatcher.toEndpoint(decorator, minuteTimeBucket);
        }
        if ((sourceServiceId = metrics.getSourceServiceId()) != 0) {
            TelemetryDataDispatcher.toServiceRelation(decorator, minuteTimeBucket);
            TelemetryDataDispatcher.toServiceInstanceRelation(decorator, minuteTimeBucket);
        }
    }

    private static void heartbeat(ServiceMeshMetricDataDecorator decorator, long minuteTimeBucket) {
        ServiceInstanceInventory serviceInstanceInventory;
        ServiceMeshMetric metrics = decorator.getMetric();
        int heartbeatCycle = 10000;
        int instanceId = metrics.getSourceServiceInstanceId();
        if (instanceId != 0) {
            serviceInstanceInventory = SERVICE_INSTANCE_CACHE.get(instanceId);
            if (Objects.nonNull(serviceInstanceInventory)) {
                if (metrics.getEndTime() - serviceInstanceInventory.getHeartbeatTime() > (long)heartbeatCycle) {
                    SERVICE_INSTANCE_INVENTORY_REGISTER.heartbeat(metrics.getSourceServiceInstanceId(), metrics.getEndTime());
                    SERVICE_INVENTORY_REGISTER.heartbeat(serviceInstanceInventory.getServiceId(), metrics.getEndTime());
                }
            } else {
                logger.warn("Can't found service by service instance id from cache, service instance id is: {}", (Object)instanceId);
            }
        }
        if (Objects.nonNull(serviceInstanceInventory = SERVICE_INSTANCE_CACHE.get(instanceId = metrics.getDestServiceInstanceId()))) {
            if (metrics.getEndTime() - serviceInstanceInventory.getHeartbeatTime() > (long)heartbeatCycle) {
                SERVICE_INSTANCE_INVENTORY_REGISTER.heartbeat(metrics.getDestServiceInstanceId(), metrics.getEndTime());
                SERVICE_INVENTORY_REGISTER.heartbeat(serviceInstanceInventory.getServiceId(), metrics.getEndTime());
            }
        } else {
            logger.warn("Can't found service by service instance id from cache, service instance id is: {}", (Object)instanceId);
        }
    }

    private static void toAll(ServiceMeshMetricDataDecorator decorator, long minuteTimeBucket) {
        ServiceMeshMetric metrics = decorator.getMetric();
        All all = new All();
        all.setTimeBucket(minuteTimeBucket);
        all.setName(TelemetryDataDispatcher.getServiceName(metrics.getDestServiceId(), metrics.getDestServiceName()));
        all.setServiceInstanceName(TelemetryDataDispatcher.getServiceInstanceName(metrics.getDestServiceInstanceId(), metrics.getDestServiceInstance()));
        all.setEndpointName(metrics.getEndpoint());
        all.setLatency(metrics.getLatency());
        all.setStatus(metrics.getStatus());
        all.setResponseCode(metrics.getResponseCode());
        all.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        SOURCE_RECEIVER.receive((Source)all);
    }

    private static void toService(ServiceMeshMetricDataDecorator decorator, long minuteTimeBucket) {
        ServiceMeshMetric metrics = decorator.getMetric();
        Service service = new Service();
        service.setTimeBucket(minuteTimeBucket);
        service.setId(metrics.getDestServiceId());
        service.setName(TelemetryDataDispatcher.getServiceName(metrics.getDestServiceId(), metrics.getDestServiceName()));
        service.setServiceInstanceName(TelemetryDataDispatcher.getServiceInstanceName(metrics.getDestServiceInstanceId(), metrics.getDestServiceInstance()));
        service.setEndpointName(metrics.getEndpoint());
        service.setLatency(metrics.getLatency());
        service.setStatus(metrics.getStatus());
        service.setResponseCode(metrics.getResponseCode());
        service.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        SOURCE_RECEIVER.receive((Source)service);
    }

    private static void toServiceRelation(ServiceMeshMetricDataDecorator decorator, long minuteTimeBucket) {
        ServiceMeshMetric metrics = decorator.getMetric();
        ServiceRelation serviceRelation = new ServiceRelation();
        serviceRelation.setTimeBucket(minuteTimeBucket);
        serviceRelation.setSourceServiceId(metrics.getSourceServiceId());
        serviceRelation.setSourceServiceName(TelemetryDataDispatcher.getServiceName(metrics.getSourceServiceId(), metrics.getSourceServiceName()));
        serviceRelation.setSourceServiceInstanceName(TelemetryDataDispatcher.getServiceInstanceName(metrics.getSourceServiceInstanceId(), metrics.getSourceServiceInstance()));
        serviceRelation.setDestServiceId(metrics.getDestServiceId());
        serviceRelation.setDestServiceName(TelemetryDataDispatcher.getServiceName(metrics.getDestServiceId(), metrics.getDestServiceName()));
        serviceRelation.setDestServiceInstanceName(TelemetryDataDispatcher.getServiceInstanceName(metrics.getDestServiceInstanceId(), metrics.getDestServiceInstance()));
        serviceRelation.setEndpoint(metrics.getEndpoint());
        serviceRelation.setLatency(metrics.getLatency());
        serviceRelation.setStatus(metrics.getStatus());
        serviceRelation.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        serviceRelation.setResponseCode(metrics.getResponseCode());
        serviceRelation.setDetectPoint(TelemetryDataDispatcher.detectPointMapping(metrics.getDetectPoint()));
        serviceRelation.setComponentId(TelemetryDataDispatcher.protocol2Component(metrics.getProtocol()));
        SOURCE_RECEIVER.receive((Source)serviceRelation);
    }

    private static void toServiceInstance(ServiceMeshMetricDataDecorator decorator, long minuteTimeBucket) {
        ServiceMeshMetric metrics = decorator.getMetric();
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setTimeBucket(minuteTimeBucket);
        serviceInstance.setId(metrics.getDestServiceInstanceId());
        serviceInstance.setName(TelemetryDataDispatcher.getServiceInstanceName(metrics.getDestServiceInstanceId(), metrics.getDestServiceInstance()));
        serviceInstance.setServiceId(metrics.getDestServiceId());
        serviceInstance.setServiceName(TelemetryDataDispatcher.getServiceName(metrics.getDestServiceId(), metrics.getDestServiceName()));
        serviceInstance.setEndpointName(metrics.getEndpoint());
        serviceInstance.setLatency(metrics.getLatency());
        serviceInstance.setStatus(metrics.getStatus());
        serviceInstance.setResponseCode(metrics.getResponseCode());
        serviceInstance.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        SOURCE_RECEIVER.receive((Source)serviceInstance);
    }

    private static void toServiceInstanceRelation(ServiceMeshMetricDataDecorator decorator, long minuteTimeBucket) {
        ServiceMeshMetric metrics = decorator.getMetric();
        ServiceInstanceRelation serviceRelation = new ServiceInstanceRelation();
        serviceRelation.setTimeBucket(minuteTimeBucket);
        serviceRelation.setSourceServiceInstanceId(metrics.getSourceServiceInstanceId());
        serviceRelation.setSourceServiceInstanceName(TelemetryDataDispatcher.getServiceInstanceName(metrics.getSourceServiceInstanceId(), metrics.getSourceServiceInstance()));
        serviceRelation.setSourceServiceId(metrics.getSourceServiceId());
        serviceRelation.setSourceServiceName(TelemetryDataDispatcher.getServiceName(metrics.getSourceServiceId(), metrics.getSourceServiceName()));
        serviceRelation.setDestServiceInstanceId(metrics.getDestServiceInstanceId());
        serviceRelation.setDestServiceInstanceName(TelemetryDataDispatcher.getServiceInstanceName(metrics.getDestServiceInstanceId(), metrics.getDestServiceInstance()));
        serviceRelation.setDestServiceId(metrics.getDestServiceId());
        serviceRelation.setDestServiceName(TelemetryDataDispatcher.getServiceName(metrics.getDestServiceId(), metrics.getDestServiceName()));
        serviceRelation.setEndpoint(metrics.getEndpoint());
        serviceRelation.setLatency(metrics.getLatency());
        serviceRelation.setStatus(metrics.getStatus());
        serviceRelation.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        serviceRelation.setResponseCode(metrics.getResponseCode());
        serviceRelation.setDetectPoint(TelemetryDataDispatcher.detectPointMapping(metrics.getDetectPoint()));
        serviceRelation.setComponentId(TelemetryDataDispatcher.protocol2Component(metrics.getProtocol()));
        SOURCE_RECEIVER.receive((Source)serviceRelation);
    }

    private static void toEndpoint(ServiceMeshMetricDataDecorator decorator, long minuteTimeBucket) {
        ServiceMeshMetric metrics = decorator.getMetric();
        Endpoint endpoint = new Endpoint();
        endpoint.setTimeBucket(minuteTimeBucket);
        endpoint.setId(decorator.getEndpointId());
        endpoint.setName(metrics.getEndpoint());
        endpoint.setServiceId(metrics.getDestServiceId());
        endpoint.setServiceName(TelemetryDataDispatcher.getServiceName(metrics.getDestServiceId(), metrics.getDestServiceName()));
        endpoint.setServiceInstanceId(metrics.getDestServiceInstanceId());
        endpoint.setServiceInstanceName(TelemetryDataDispatcher.getServiceInstanceName(metrics.getDestServiceInstanceId(), metrics.getDestServiceInstance()));
        endpoint.setLatency(metrics.getLatency());
        endpoint.setStatus(metrics.getStatus());
        endpoint.setResponseCode(metrics.getResponseCode());
        endpoint.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        SOURCE_RECEIVER.receive((Source)endpoint);
    }

    private static RequestType protocol2Type(Protocol protocol) {
        switch (protocol) {
            case gRPC: {
                return RequestType.gRPC;
            }
            case HTTP: {
                return RequestType.HTTP;
            }
        }
        return RequestType.RPC;
    }

    private static int protocol2Component(Protocol protocol) {
        switch (protocol) {
            case gRPC: {
                return 23;
            }
            case HTTP: {
                return 49;
            }
        }
        return 50;
    }

    private static org.apache.skywalking.oap.server.core.source.DetectPoint detectPointMapping(DetectPoint detectPoint) {
        switch (detectPoint) {
            case client: {
                return org.apache.skywalking.oap.server.core.source.DetectPoint.CLIENT;
            }
            case server: {
                return org.apache.skywalking.oap.server.core.source.DetectPoint.SERVER;
            }
            case proxy: {
                return org.apache.skywalking.oap.server.core.source.DetectPoint.PROXY;
            }
        }
        return org.apache.skywalking.oap.server.core.source.DetectPoint.SERVER;
    }

    private static String getServiceName(int serviceId, String serviceName) {
        if (Strings.isBlank((String)serviceName)) {
            return SERVICE_CACHE.get(serviceId).getName();
        }
        return serviceName;
    }

    private static String getServiceInstanceName(int serviceInstanceId, String serviceInstanceName) {
        if (Strings.isBlank((String)serviceInstanceName)) {
            return SERVICE_INSTANCE_CACHE.get(serviceInstanceId).getName();
        }
        return serviceInstanceName;
    }
}

