/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import com.google.protobuf.AbstractMessageLite;
import java.io.IOException;
import java.util.List;
import org.apache.skywalking.aop.server.receiver.mesh.MeshModuleConfig;
import org.apache.skywalking.aop.server.receiver.mesh.ServiceMeshMetricDataDecorator;
import org.apache.skywalking.aop.server.receiver.mesh.TelemetryDataDispatcher;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.apm.network.servicemesh.ServiceMeshMetric;
import org.apache.skywalking.oap.server.library.buffer.BufferData;
import org.apache.skywalking.oap.server.library.buffer.BufferStream;
import org.apache.skywalking.oap.server.library.buffer.DataStreamReader;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public class MeshDataBufferFileCache
implements IConsumer<ServiceMeshMetricDataDecorator>,
DataStreamReader.CallBack<ServiceMeshMetric> {
    private MeshModuleConfig config;
    private DataCarrier<ServiceMeshMetricDataDecorator> dataCarrier;
    private BufferStream<ServiceMeshMetric> stream;
    private CounterMetrics meshBufferFileIn;
    private CounterMetrics meshBufferFileRetry;
    private CounterMetrics meshBufferFileOut;

    public MeshDataBufferFileCache(MeshModuleConfig config, ModuleManager moduleManager) {
        this.config = config;
        this.dataCarrier = new DataCarrier("MeshDataBufferFileCache", 3, 1024);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.meshBufferFileIn = metricsCreator.createCounter("mesh_buffer_file_in", "The number of mesh telemetry into the buffer file", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.meshBufferFileRetry = metricsCreator.createCounter("mesh_buffer_file_retry", "The number of retry mesh telemetry from the buffer file, but haven't registered successfully.", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.meshBufferFileOut = metricsCreator.createCounter("mesh_buffer_file_out", "The number of mesh telemetry out of the buffer file", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
    }

    void start() throws IOException {
        this.dataCarrier.consume((IConsumer)this, 1);
        BufferStream.Builder builder = new BufferStream.Builder(this.config.getBufferPath());
        builder.cleanWhenRestart(this.config.isBufferFileCleanWhenRestart());
        builder.dataFileMaxSize(this.config.getBufferDataMaxFileSize());
        builder.offsetFileMaxSize(this.config.getBufferOffsetMaxFileSize());
        builder.parser(ServiceMeshMetric.parser());
        builder.callBack((DataStreamReader.CallBack)this);
        this.stream = builder.build();
        this.stream.initialize();
    }

    public void init() {
    }

    public void in(ServiceMeshMetric metrics) {
        this.dataCarrier.produce((Object)new ServiceMeshMetricDataDecorator(metrics));
    }

    public void consume(List<ServiceMeshMetricDataDecorator> data) {
        for (ServiceMeshMetricDataDecorator decorator : data) {
            if (decorator.tryMetaDataRegister()) {
                TelemetryDataDispatcher.doDispatch(decorator);
                continue;
            }
            this.meshBufferFileIn.inc();
            this.stream.write((AbstractMessageLite)decorator.getMetric());
        }
    }

    public void onError(List<ServiceMeshMetricDataDecorator> data, Throwable t) {
    }

    public void onExit() {
    }

    public boolean call(BufferData<ServiceMeshMetric> bufferData) {
        ServiceMeshMetricDataDecorator decorator = new ServiceMeshMetricDataDecorator((ServiceMeshMetric)bufferData.getMessageType());
        if (decorator.tryMetaDataRegister()) {
            this.meshBufferFileOut.inc();
            TelemetryDataDispatcher.doDispatch(decorator);
            return true;
        }
        this.meshBufferFileRetry.inc();
        return false;
    }
}

