/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import io.grpc.BindableService;
import java.io.IOException;
import org.apache.skywalking.aop.server.receiver.mesh.MeshDataBufferFileCache;
import org.apache.skywalking.aop.server.receiver.mesh.MeshGRPCHandler;
import org.apache.skywalking.aop.server.receiver.mesh.MeshModuleConfig;
import org.apache.skywalking.aop.server.receiver.mesh.MeshReceiverModule;
import org.apache.skywalking.aop.server.receiver.mesh.TelemetryDataDispatcher;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.receiver.sharing.server.CoreRegisterLinker;

public class MeshReceiverProvider
extends ModuleProvider {
    private MeshModuleConfig config = new MeshModuleConfig();

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return MeshReceiverModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        MeshDataBufferFileCache cache = new MeshDataBufferFileCache(this.config, this.getManager());
        try {
            cache.start();
            TelemetryDataDispatcher.setCache(cache, this.getManager());
        }
        catch (IOException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        CoreRegisterLinker.setModuleManager((ModuleManager)this.getManager());
        GRPCHandlerRegister service = (GRPCHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        service.addHandler((BindableService)new MeshGRPCHandler(this.getManager()));
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "core", "receiver-sharing-server"};
    }
}

