/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import io.grpc.stub.StreamObserver;
import org.apache.skywalking.aop.server.receiver.mesh.TelemetryDataDispatcher;
import org.apache.skywalking.apm.network.servicemesh.v3.MeshProbeDownstream;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetricServiceGrpc;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGRPCHandler
extends ServiceMeshMetricServiceGrpc.ServiceMeshMetricServiceImplBase {
    private static final Logger logger = LoggerFactory.getLogger(MeshGRPCHandler.class);

    public MeshGRPCHandler(ModuleManager moduleManager) {
    }

    public StreamObserver<ServiceMeshMetric> collect(final StreamObserver<MeshProbeDownstream> responseObserver) {
        return new StreamObserver<ServiceMeshMetric>(){

            public void onNext(ServiceMeshMetric metrics) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received mesh metrics: {}", (Object)metrics);
                }
                TelemetryDataDispatcher.process(metrics.toBuilder());
            }

            public void onError(Throwable throwable) {
                logger.error(throwable.getMessage(), throwable);
                responseObserver.onCompleted();
            }

            public void onCompleted() {
                responseObserver.onNext((Object)MeshProbeDownstream.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

