/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.Protocol;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetric;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.NodeType;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.All;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.Endpoint;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.RequestType;
import org.apache.skywalking.oap.server.core.source.Service;
import org.apache.skywalking.oap.server.core.source.ServiceInstance;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceRelation;
import org.apache.skywalking.oap.server.core.source.ServiceRelation;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryDataDispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelemetryDataDispatcher.class);
    private static SourceReceiver SOURCE_RECEIVER;
    private static NamingControl NAME_LENGTH_CONTROL;
    private static HistogramMetrics MESH_ANALYSIS_METRICS;
    private static CounterMetrics MESH_ERROR_METRICS;

    private TelemetryDataDispatcher() {
    }

    public static void init(ModuleManager moduleManager) {
        SOURCE_RECEIVER = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        NAME_LENGTH_CONTROL = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        MESH_ANALYSIS_METRICS = metricsCreator.createHistogramMetric("mesh_analysis_latency", "The process latency of service mesh telemetry", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
        MESH_ERROR_METRICS = metricsCreator.createCounter("mesh_analysis_error_count", "The error number of mesh analysis", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
    }

    public static void process(ServiceMeshMetric.Builder data) {
        try (HistogramMetrics.Timer ignored = MESH_ANALYSIS_METRICS.createTimer();){
            if (data.getSourceServiceName() != null) {
                data.setSourceServiceName(NAME_LENGTH_CONTROL.formatServiceName(data.getSourceServiceName()));
            }
            if (data.getSourceServiceInstance() != null) {
                data.setSourceServiceInstance(NAME_LENGTH_CONTROL.formatInstanceName(data.getSourceServiceInstance()));
            }
            if (data.getDestServiceName() != null) {
                data.setDestServiceName(NAME_LENGTH_CONTROL.formatServiceName(data.getDestServiceName()));
            }
            if (data.getDestServiceInstance() != null) {
                data.setDestServiceInstance(NAME_LENGTH_CONTROL.formatInstanceName(data.getDestServiceInstance()));
            }
            if (data.getEndpoint() != null) {
                data.setEndpoint(NAME_LENGTH_CONTROL.formatEndpointName(data.getDestServiceName(), data.getEndpoint()));
            }
            if (data.getInternalErrorCode() == null) {
                data.setInternalErrorCode("");
            }
            TelemetryDataDispatcher.doDispatch(data);
        }
        catch (Exception e) {
            MESH_ERROR_METRICS.inc();
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    static void doDispatch(ServiceMeshMetric.Builder metrics) {
        String sourceService;
        long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)metrics.getStartTime());
        if (org.apache.skywalking.apm.network.common.v3.DetectPoint.server.equals((Object)metrics.getDetectPoint())) {
            TelemetryDataDispatcher.toAll(metrics, minuteTimeBucket);
            TelemetryDataDispatcher.toService(metrics, minuteTimeBucket);
            TelemetryDataDispatcher.toServiceInstance(metrics, minuteTimeBucket);
            TelemetryDataDispatcher.toEndpoint(metrics, minuteTimeBucket);
        }
        if (StringUtil.isNotEmpty((String)(sourceService = metrics.getSourceServiceName()))) {
            TelemetryDataDispatcher.toServiceRelation(metrics, minuteTimeBucket);
            TelemetryDataDispatcher.toServiceInstanceRelation(metrics, minuteTimeBucket);
        }
    }

    private static void toAll(ServiceMeshMetric.Builder metrics, long minuteTimeBucket) {
        All all = new All();
        all.setTimeBucket(minuteTimeBucket);
        all.setName(metrics.getDestServiceName());
        all.setServiceInstanceName(metrics.getDestServiceInstance());
        all.setEndpointName(metrics.getEndpoint());
        all.setLatency(metrics.getLatency());
        all.setStatus(metrics.getStatus());
        all.setResponseCode(metrics.getResponseCode());
        all.setHttpResponseStatusCode(metrics.getResponseCode());
        all.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        SOURCE_RECEIVER.receive((ISource)all);
    }

    private static void toService(ServiceMeshMetric.Builder metrics, long minuteTimeBucket) {
        Service service = new Service();
        service.setTimeBucket(minuteTimeBucket);
        service.setName(metrics.getDestServiceName());
        service.setNodeType(NodeType.Normal);
        service.setServiceInstanceName(metrics.getDestServiceInstance());
        service.setEndpointName(metrics.getEndpoint());
        service.setLatency(metrics.getLatency());
        service.setStatus(metrics.getStatus());
        service.setResponseCode(metrics.getResponseCode());
        service.setHttpResponseStatusCode(metrics.getResponseCode());
        service.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        service.getSideCar().setInternalErrorCode(metrics.getInternalErrorCode());
        service.getTcpInfo().setReceivedBytes(metrics.getTcp().getReceivedBytes());
        service.getTcpInfo().setSentBytes(metrics.getTcp().getSentBytes());
        SOURCE_RECEIVER.receive((ISource)service);
    }

    private static void toServiceRelation(ServiceMeshMetric.Builder metrics, long minuteTimeBucket) {
        ServiceRelation serviceRelation = new ServiceRelation();
        serviceRelation.setTimeBucket(minuteTimeBucket);
        serviceRelation.setSourceServiceName(metrics.getSourceServiceName());
        serviceRelation.setSourceServiceNodeType(NodeType.Normal);
        serviceRelation.setSourceServiceInstanceName(metrics.getSourceServiceInstance());
        serviceRelation.setDestServiceName(metrics.getDestServiceName());
        serviceRelation.setDestServiceNodeType(NodeType.Normal);
        serviceRelation.setDestServiceInstanceName(metrics.getDestServiceInstance());
        serviceRelation.setEndpoint(metrics.getEndpoint());
        serviceRelation.setLatency(metrics.getLatency());
        serviceRelation.setStatus(metrics.getStatus());
        serviceRelation.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        serviceRelation.setResponseCode(metrics.getResponseCode());
        serviceRelation.setHttpResponseStatusCode(metrics.getResponseCode());
        serviceRelation.setDetectPoint(TelemetryDataDispatcher.detectPointMapping(metrics.getDetectPoint()));
        serviceRelation.setComponentId(TelemetryDataDispatcher.protocol2Component(metrics.getProtocol()));
        serviceRelation.setTlsMode(metrics.getTlsMode());
        serviceRelation.getSideCar().setInternalErrorCode(metrics.getInternalErrorCode());
        serviceRelation.getTcpInfo().setReceivedBytes(metrics.getTcp().getReceivedBytes());
        serviceRelation.getTcpInfo().setSentBytes(metrics.getTcp().getSentBytes());
        SOURCE_RECEIVER.receive((ISource)serviceRelation);
    }

    private static void toServiceInstance(ServiceMeshMetric.Builder metrics, long minuteTimeBucket) {
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setTimeBucket(minuteTimeBucket);
        serviceInstance.setName(metrics.getDestServiceInstance());
        serviceInstance.setServiceName(metrics.getDestServiceName());
        serviceInstance.setNodeType(NodeType.Normal);
        serviceInstance.setEndpointName(metrics.getEndpoint());
        serviceInstance.setLatency(metrics.getLatency());
        serviceInstance.setStatus(metrics.getStatus());
        serviceInstance.setResponseCode(metrics.getResponseCode());
        serviceInstance.setHttpResponseStatusCode(metrics.getResponseCode());
        serviceInstance.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        serviceInstance.getSideCar().setInternalErrorCode(metrics.getInternalErrorCode());
        serviceInstance.getTcpInfo().setReceivedBytes(metrics.getTcp().getReceivedBytes());
        serviceInstance.getTcpInfo().setSentBytes(metrics.getTcp().getSentBytes());
        SOURCE_RECEIVER.receive((ISource)serviceInstance);
    }

    private static void toServiceInstanceRelation(ServiceMeshMetric.Builder metrics, long minuteTimeBucket) {
        ServiceInstanceRelation serviceRelation = new ServiceInstanceRelation();
        serviceRelation.setTimeBucket(minuteTimeBucket);
        serviceRelation.setSourceServiceInstanceName(metrics.getSourceServiceInstance());
        serviceRelation.setSourceServiceName(metrics.getSourceServiceName());
        serviceRelation.setSourceServiceNodeType(NodeType.Normal);
        serviceRelation.setDestServiceInstanceName(metrics.getDestServiceInstance());
        serviceRelation.setDestServiceNodeType(NodeType.Normal);
        serviceRelation.setDestServiceName(metrics.getDestServiceName());
        serviceRelation.setEndpoint(metrics.getEndpoint());
        serviceRelation.setLatency(metrics.getLatency());
        serviceRelation.setStatus(metrics.getStatus());
        serviceRelation.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        serviceRelation.setResponseCode(metrics.getResponseCode());
        serviceRelation.setHttpResponseStatusCode(metrics.getResponseCode());
        serviceRelation.setDetectPoint(TelemetryDataDispatcher.detectPointMapping(metrics.getDetectPoint()));
        serviceRelation.setComponentId(TelemetryDataDispatcher.protocol2Component(metrics.getProtocol()));
        serviceRelation.setTlsMode(metrics.getTlsMode());
        serviceRelation.getSideCar().setInternalErrorCode(metrics.getInternalErrorCode());
        serviceRelation.getTcpInfo().setReceivedBytes(metrics.getTcp().getReceivedBytes());
        serviceRelation.getTcpInfo().setSentBytes(metrics.getTcp().getSentBytes());
        SOURCE_RECEIVER.receive((ISource)serviceRelation);
    }

    private static void toEndpoint(ServiceMeshMetric.Builder metrics, long minuteTimeBucket) {
        Endpoint endpoint = new Endpoint();
        endpoint.setTimeBucket(minuteTimeBucket);
        endpoint.setName(metrics.getEndpoint());
        endpoint.setServiceName(metrics.getDestServiceName());
        endpoint.setServiceNodeType(NodeType.Normal);
        endpoint.setServiceInstanceName(metrics.getDestServiceInstance());
        endpoint.setLatency(metrics.getLatency());
        endpoint.setStatus(metrics.getStatus());
        endpoint.setResponseCode(metrics.getResponseCode());
        endpoint.setHttpResponseStatusCode(metrics.getResponseCode());
        endpoint.setType(TelemetryDataDispatcher.protocol2Type(metrics.getProtocol()));
        endpoint.getSideCar().setInternalErrorCode(metrics.getInternalErrorCode());
        SOURCE_RECEIVER.receive((ISource)endpoint);
    }

    private static RequestType protocol2Type(Protocol protocol) {
        switch (protocol) {
            case gRPC: {
                return RequestType.gRPC;
            }
            case HTTP: {
                return RequestType.HTTP;
            }
            case TCP: {
                return RequestType.TCP;
            }
        }
        return RequestType.RPC;
    }

    private static int protocol2Component(Protocol protocol) {
        switch (protocol) {
            case gRPC: {
                return 23;
            }
            case HTTP: {
                return 49;
            }
            case TCP: {
                return 110;
            }
        }
        return 50;
    }

    private static DetectPoint detectPointMapping(org.apache.skywalking.apm.network.common.v3.DetectPoint detectPoint) {
        switch (detectPoint) {
            case client: {
                return DetectPoint.CLIENT;
            }
            case proxy: {
                return DetectPoint.PROXY;
            }
        }
        return DetectPoint.SERVER;
    }
}

