/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.sharing.server;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.remote.health.HealthCheckServiceHandler;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegisterImpl;
import org.apache.skywalking.oap.server.core.server.HTTPHandlerRegister;
import org.apache.skywalking.oap.server.core.server.HTTPHandlerRegisterImpl;
import org.apache.skywalking.oap.server.core.server.auth.AuthenticationInterceptor;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCServer;
import org.apache.skywalking.oap.server.library.server.http.HTTPServer;
import org.apache.skywalking.oap.server.library.server.http.HTTPServerConfig;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.sharing.server.ReceiverGRPCHandlerRegister;
import org.apache.skywalking.oap.server.receiver.sharing.server.ReceiverHTTPHandlerRegister;
import org.apache.skywalking.oap.server.receiver.sharing.server.SharingServerConfig;
import org.apache.skywalking.oap.server.receiver.sharing.server.SharingServerModule;

public class SharingServerModuleProvider
extends ModuleProvider {
    private SharingServerConfig config;
    private GRPCServer grpcServer;
    private HTTPServer httpServer;
    private ReceiverGRPCHandlerRegister receiverGRPCHandlerRegister;
    private ReceiverHTTPHandlerRegister receiverHTTPHandlerRegister;
    private AuthenticationInterceptor authenticationInterceptor;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return SharingServerModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<SharingServerConfig>(){

            public Class type() {
                return SharingServerConfig.class;
            }

            public void onInitialized(SharingServerConfig initialized) {
                SharingServerModuleProvider.this.config = initialized;
            }
        };
    }

    public void prepare() {
        if (this.config.getRestPort() > 0) {
            HTTPServerConfig httpServerConfig = HTTPServerConfig.builder().host(this.config.getRestHost()).port(this.config.getRestPort()).contextPath(this.config.getRestContextPath()).maxThreads(this.config.getRestMaxThreads()).acceptQueueSize(this.config.getRestAcceptQueueSize()).idleTimeOut(this.config.getRestIdleTimeOut()).maxRequestHeaderSize(this.config.getHttpMaxRequestHeaderSize()).build();
            httpServerConfig.setHost(Strings.isBlank((String)this.config.getRestHost()) ? "0.0.0.0" : this.config.getRestHost());
            httpServerConfig.setPort(this.config.getRestPort());
            httpServerConfig.setContextPath(this.config.getRestContextPath());
            this.setBootingParameter("oap.external.http.host", this.config.getRestHost());
            this.setBootingParameter("oap.external.http.port", this.config.getRestPort());
            this.httpServer = new HTTPServer(httpServerConfig);
            this.httpServer.initialize();
            this.registerServiceImplementation(HTTPHandlerRegister.class, (Service)new HTTPHandlerRegisterImpl(this.httpServer));
        } else {
            this.receiverHTTPHandlerRegister = new ReceiverHTTPHandlerRegister();
            this.registerServiceImplementation(HTTPHandlerRegister.class, (Service)this.receiverHTTPHandlerRegister);
        }
        if (StringUtil.isNotEmpty((String)this.config.getAuthentication())) {
            this.authenticationInterceptor = new AuthenticationInterceptor(this.config.getAuthentication());
        }
        if (this.config.getGRPCPort() != 0 && !RunningMode.isInitMode()) {
            this.grpcServer = this.config.isGRPCSslEnabled() ? new GRPCServer(Strings.isBlank((String)this.config.getGRPCHost()) ? "0.0.0.0" : this.config.getGRPCHost(), this.config.getGRPCPort(), this.config.getGRPCSslCertChainPath(), this.config.getGRPCSslKeyPath(), this.config.getGRPCSslTrustedCAsPath()) : new GRPCServer(Strings.isBlank((String)this.config.getGRPCHost()) ? "0.0.0.0" : this.config.getGRPCHost(), this.config.getGRPCPort());
            this.setBootingParameter("oap.external.grpc.host", this.config.getGRPCHost());
            this.setBootingParameter("oap.external.grpc.port", this.config.getGRPCPort());
            if (this.config.getMaxMessageSize() > 0) {
                this.grpcServer.setMaxMessageSize(this.config.getMaxMessageSize());
            }
            if (this.config.getMaxConcurrentCallsPerConnection() > 0) {
                this.grpcServer.setMaxConcurrentCallsPerConnection(this.config.getMaxConcurrentCallsPerConnection());
            }
            if (this.config.getGRPCThreadPoolSize() > 0) {
                this.grpcServer.setThreadPoolSize(this.config.getGRPCThreadPoolSize());
            }
            this.grpcServer.initialize();
            GRPCHandlerRegisterImpl grpcHandlerRegister = new GRPCHandlerRegisterImpl(this.grpcServer);
            if (Objects.nonNull(this.authenticationInterceptor)) {
                grpcHandlerRegister.addFilter((ServerInterceptor)this.authenticationInterceptor);
            }
            this.registerServiceImplementation(GRPCHandlerRegister.class, (Service)grpcHandlerRegister);
        } else {
            this.receiverGRPCHandlerRegister = new ReceiverGRPCHandlerRegister();
            if (Objects.nonNull(this.authenticationInterceptor)) {
                this.receiverGRPCHandlerRegister.addFilter((ServerInterceptor)this.authenticationInterceptor);
            }
            this.registerServiceImplementation(GRPCHandlerRegister.class, (Service)this.receiverGRPCHandlerRegister);
        }
    }

    public void start() {
        if (Objects.nonNull(this.grpcServer)) {
            this.grpcServer.addHandler((BindableService)new HealthCheckServiceHandler());
        }
        if (Objects.nonNull(this.receiverGRPCHandlerRegister)) {
            this.receiverGRPCHandlerRegister.setGrpcHandlerRegister((GRPCHandlerRegister)this.getManager().find("core").provider().getService(GRPCHandlerRegister.class));
        }
        if (Objects.nonNull(this.receiverHTTPHandlerRegister)) {
            this.receiverHTTPHandlerRegister.setHttpHandlerRegister((HTTPHandlerRegister)this.getManager().find("core").provider().getService(HTTPHandlerRegister.class));
        }
    }

    public void notifyAfterCompleted() throws ModuleStartException {
        try {
            if (Objects.nonNull(this.grpcServer) && !RunningMode.isInitMode()) {
                this.grpcServer.start();
            }
            if (Objects.nonNull(this.httpServer) && !RunningMode.isInitMode()) {
                this.httpServer.start();
            }
        }
        catch (ServerException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

