/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.receiver.trace.provider.TraceModuleProvider;

public class DBLatencyThresholdsAndWatcher
extends ConfigChangeWatcher {
    private AtomicReference<Map<String, Integer>> thresholds = new AtomicReference(new HashMap());
    private AtomicReference<String> settingsString = new AtomicReference<String>("");

    public DBLatencyThresholdsAndWatcher(String config, TraceModuleProvider provider) {
        super("receiver-trace", (ModuleProvider)provider, "slowDBAccessThreshold");
        this.activeSetting(config);
    }

    private void activeSetting(String config) {
        String[] settings;
        HashMap<String, Integer> newThresholds = new HashMap<String, Integer>();
        for (String setting : settings = config.split(",")) {
            String[] typeValue = setting.split(":");
            if (typeValue.length != 2) continue;
            newThresholds.put(typeValue[0].trim().toLowerCase(), Integer.parseInt(typeValue[1].trim()));
        }
        if (!newThresholds.containsKey("default")) {
            newThresholds.put("default", 10000);
        }
        this.thresholds.set(newThresholds);
        this.settingsString.set(config);
    }

    public int getThreshold(String type) {
        type = type.toLowerCase();
        if (this.thresholds.get().containsKey(type)) {
            return this.thresholds.get().get(type);
        }
        return this.thresholds.get().get("default");
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        if (ConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.activeSetting("");
        } else {
            this.activeSetting(value.getNewValue());
        }
    }

    public String value() {
        return this.settingsString.get();
    }
}

