/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider;

import io.grpc.BindableService;
import java.io.IOException;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.configuration.api.DynamicConfigurationService;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.core.server.JettyHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.jetty.JettyHandler;
import org.apache.skywalking.oap.server.receiver.trace.module.TraceModule;
import org.apache.skywalking.oap.server.receiver.trace.provider.DBLatencyThresholdsAndWatcher;
import org.apache.skywalking.oap.server.receiver.trace.provider.TraceServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.trace.provider.UninstrumentedGatewaysConfig;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.grpc.TraceSegmentServiceHandler;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.TraceSegmentServletHandler;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v6.grpc.TraceSegmentReportServiceHandler;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.ISegmentParserService;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.SegmentParse;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.SegmentParseV2;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.SegmentParserListenerManager;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.SegmentParserServiceImpl;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.endpoint.MultiScopesSpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.segment.SegmentSpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.service.ServiceInstanceMappingSpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.service.ServiceMappingSpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization.SegmentStandardizationWorker;

public class TraceModuleProvider
extends ModuleProvider {
    private final TraceServiceModuleConfig moduleConfig = new TraceServiceModuleConfig();
    private SegmentParse.Producer segmentProducer;
    private SegmentParseV2.Producer segmentProducerV2;
    private DBLatencyThresholdsAndWatcher thresholds;
    private UninstrumentedGatewaysConfig uninstrumentedGatewaysConfig;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return TraceModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.moduleConfig;
    }

    public void prepare() throws ServiceNotProvidedException {
        this.thresholds = new DBLatencyThresholdsAndWatcher(this.moduleConfig.getSlowDBAccessThreshold(), this);
        this.uninstrumentedGatewaysConfig = new UninstrumentedGatewaysConfig(this);
        this.moduleConfig.setDbLatencyThresholdsAndWatcher(this.thresholds);
        this.moduleConfig.setUninstrumentedGatewaysConfig(this.uninstrumentedGatewaysConfig);
        this.segmentProducer = new SegmentParse.Producer(this.getManager(), this.listenerManager(), this.moduleConfig);
        this.segmentProducerV2 = new SegmentParseV2.Producer(this.getManager(), this.listenerManager(), this.moduleConfig);
        this.registerServiceImplementation(ISegmentParserService.class, new SegmentParserServiceImpl(this.segmentProducerV2));
    }

    public SegmentParserListenerManager listenerManager() {
        SegmentParserListenerManager listenerManager = new SegmentParserListenerManager();
        if (this.moduleConfig.isTraceAnalysis()) {
            listenerManager.add(new MultiScopesSpanListener.Factory());
            listenerManager.add(new ServiceMappingSpanListener.Factory());
            listenerManager.add(new ServiceInstanceMappingSpanListener.Factory());
        }
        listenerManager.add(new SegmentSpanListener.Factory(this.moduleConfig.getSampleRate()));
        return listenerManager;
    }

    public void start() throws ModuleStartException {
        DynamicConfigurationService dynamicConfigurationService = (DynamicConfigurationService)this.getManager().find("configuration").provider().getService(DynamicConfigurationService.class);
        GRPCHandlerRegister grpcHandlerRegister = (GRPCHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        JettyHandlerRegister jettyHandlerRegister = (JettyHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(JettyHandlerRegister.class);
        try {
            dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.thresholds);
            dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.uninstrumentedGatewaysConfig);
            grpcHandlerRegister.addHandler((BindableService)new TraceSegmentServiceHandler(this.segmentProducer));
            grpcHandlerRegister.addHandler((BindableService)new TraceSegmentReportServiceHandler(this.segmentProducerV2, this.getManager()));
            jettyHandlerRegister.addHandler((JettyHandler)new TraceSegmentServletHandler(this.segmentProducer));
            SegmentStandardizationWorker standardizationWorker = new SegmentStandardizationWorker((ModuleDefineHolder)this.getManager(), this.segmentProducer, this.moduleConfig.getBufferPath() + "v5", this.moduleConfig.getBufferOffsetMaxFileSize(), this.moduleConfig.getBufferDataMaxFileSize(), this.moduleConfig.isBufferFileCleanWhenRestart(), false);
            this.segmentProducer.setStandardizationWorker(standardizationWorker);
            SegmentStandardizationWorker standardizationWorkerV2 = new SegmentStandardizationWorker((ModuleDefineHolder)this.getManager(), this.segmentProducerV2, this.moduleConfig.getBufferPath(), this.moduleConfig.getBufferOffsetMaxFileSize(), this.moduleConfig.getBufferDataMaxFileSize(), this.moduleConfig.isBufferFileCleanWhenRestart(), true);
            this.segmentProducerV2.setStandardizationWorker(standardizationWorkerV2);
        }
        catch (IOException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "core", "receiver-sharing-server", "configuration"};
    }
}

