/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.grpc;

import io.grpc.stub.StreamObserver;
import org.apache.skywalking.apm.network.language.agent.Downstream;
import org.apache.skywalking.apm.network.language.agent.TraceSegmentServiceGrpc;
import org.apache.skywalking.apm.network.language.agent.UpstreamSegment;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.grpc.SegmentCounter;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.SegmentParse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSegmentServiceHandler
extends TraceSegmentServiceGrpc.TraceSegmentServiceImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(TraceSegmentServiceHandler.class);
    private final Boolean debug = System.getProperty("debug") != null;
    private final SegmentParse.Producer segmentProducer;

    public TraceSegmentServiceHandler(SegmentParse.Producer segmentProducer) {
        this.segmentProducer = segmentProducer;
    }

    public StreamObserver<UpstreamSegment> collect(final StreamObserver<Downstream> responseObserver) {
        return new StreamObserver<UpstreamSegment>(){

            public void onNext(UpstreamSegment segment) {
                long count;
                if (logger.isDebugEnabled()) {
                    logger.debug("receive segment");
                }
                TraceSegmentServiceHandler.this.segmentProducer.send(segment, SegmentParse.Source.Agent);
                if (TraceSegmentServiceHandler.this.debug.booleanValue() && (count = SegmentCounter.INSTANCE.incrementAndGet()) % 100000L == 0L) {
                    logger.info("received segment count: {}", (Object)count);
                }
            }

            public void onError(Throwable throwable) {
                logger.error(throwable.getMessage(), throwable);
                responseObserver.onCompleted();
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Downstream.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

