/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.oap.server.library.server.jetty.JettyJsonHandler;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader.TraceSegment;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader.TraceSegmentJsonReader;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.SegmentParse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSegmentServletHandler
extends JettyJsonHandler {
    private static final Logger logger = LoggerFactory.getLogger(TraceSegmentServletHandler.class);
    private final SegmentParse.Producer segmentProducer;
    private TraceSegmentJsonReader jsonReader = new TraceSegmentJsonReader();

    public TraceSegmentServletHandler(SegmentParse.Producer segmentProducer) {
        this.segmentProducer = segmentProducer;
    }

    public String pathSpec() {
        return "/segments";
    }

    protected JsonElement doGet(HttpServletRequest req) {
        throw new UnsupportedOperationException();
    }

    protected JsonElement doPost(HttpServletRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug("receive stream segment");
        }
        try {
            BufferedReader bufferedReader = req.getReader();
            this.read(bufferedReader);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void read(BufferedReader bufferedReader) throws IOException {
        JsonReader reader = new JsonReader((Reader)bufferedReader);
        reader.beginArray();
        while (reader.hasNext()) {
            TraceSegment traceSegment = this.jsonReader.read(reader);
            this.segmentProducer.send(traceSegment.getUpstreamSegment(), SegmentParse.Source.Agent);
        }
        reader.endArray();
    }
}

