/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator;

import java.util.Objects;
import org.apache.skywalking.apm.network.language.agent.TraceSegmentObject;
import org.apache.skywalking.apm.network.language.agent.UniqueId;
import org.apache.skywalking.apm.network.language.agent.v2.SegmentObject;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SpanDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.StandardBuilder;

public class SegmentDecorator
implements StandardBuilder {
    private boolean isOrigin = true;
    private final TraceSegmentObject segmentObject;
    private TraceSegmentObject.Builder segmentBuilder;
    private final boolean isV2;
    private final SegmentObject segmentObjectV2;
    private SegmentObject.Builder segmentBuilderV2;
    private final SpanDecorator[] spanDecorators;

    public SegmentDecorator(TraceSegmentObject segmentObject) {
        this.segmentObject = segmentObject;
        this.segmentObjectV2 = null;
        this.spanDecorators = new SpanDecorator[segmentObject.getSpansCount()];
        this.isV2 = false;
    }

    public SegmentDecorator(SegmentObject segmentObjectV2) {
        this.segmentObjectV2 = segmentObjectV2;
        this.segmentObject = null;
        this.spanDecorators = new SpanDecorator[segmentObjectV2.getSpansCount()];
        this.isV2 = true;
    }

    public int getServiceId() {
        return this.isV2 ? this.segmentObjectV2.getServiceId() : this.segmentObject.getApplicationId();
    }

    public int getServiceInstanceId() {
        return this.isV2 ? this.segmentObjectV2.getServiceInstanceId() : this.segmentObject.getApplicationInstanceId();
    }

    public UniqueId getTraceSegmentId() {
        return this.isV2 ? this.segmentObjectV2.getTraceSegmentId() : this.segmentObject.getTraceSegmentId();
    }

    public int getSpansCount() {
        return this.isV2 ? this.segmentObjectV2.getSpansCount() : this.segmentObject.getSpansCount();
    }

    public SpanDecorator getSpans(int index) {
        if (Objects.isNull(this.spanDecorators[index])) {
            this.spanDecorators[index] = this.isOrigin ? (this.isV2 ? new SpanDecorator(this.segmentObjectV2.getSpans(index), (StandardBuilder)this) : new SpanDecorator(this.segmentObject.getSpans(index), (StandardBuilder)this)) : (this.isV2 ? new SpanDecorator(this.segmentBuilderV2.getSpansBuilder(index), (StandardBuilder)this) : new SpanDecorator(this.segmentBuilder.getSpansBuilder(index), (StandardBuilder)this));
        }
        return this.spanDecorators[index];
    }

    public byte[] toByteArray() {
        if (this.isOrigin) {
            return this.isV2 ? this.segmentObjectV2.toByteArray() : this.segmentObject.toByteArray();
        }
        return this.segmentBuilder.build().toByteArray();
    }

    @Override
    public void toBuilder() {
        if (this.isOrigin) {
            this.isOrigin = false;
            if (this.isV2) {
                this.segmentBuilderV2 = this.segmentObjectV2.toBuilder();
            } else {
                this.segmentBuilder = this.segmentObject.toBuilder();
            }
        }
    }
}

