/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.network.common.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.KeyWithStringValue;
import org.apache.skywalking.apm.network.language.agent.SpanLayer;
import org.apache.skywalking.apm.network.language.agent.SpanObject;
import org.apache.skywalking.apm.network.language.agent.SpanType;
import org.apache.skywalking.apm.network.language.agent.v2.SpanObjectV2;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.ReferenceDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.StandardBuilder;

public class SpanDecorator
implements StandardBuilder {
    private final boolean isV2;
    private boolean isOrigin = true;
    private StandardBuilder standardBuilder;
    private SpanObject spanObject;
    private SpanObjectV2 spanObjectV2;
    private SpanObject.Builder spanBuilder;
    private SpanObjectV2.Builder spanBuilderV2;
    private final ReferenceDecorator[] referenceDecorators;

    public SpanDecorator(SpanObject spanObject, StandardBuilder standardBuilder) {
        this.spanObject = spanObject;
        this.standardBuilder = standardBuilder;
        this.referenceDecorators = new ReferenceDecorator[spanObject.getRefsCount()];
        this.isV2 = false;
    }

    public SpanDecorator(SpanObject.Builder spanBuilder, StandardBuilder standardBuilder) {
        this.spanBuilder = spanBuilder;
        this.standardBuilder = standardBuilder;
        this.isOrigin = false;
        this.referenceDecorators = new ReferenceDecorator[spanBuilder.getRefsCount()];
        this.isV2 = false;
    }

    public SpanDecorator(SpanObjectV2 spanObject, StandardBuilder standardBuilder) {
        this.spanObjectV2 = spanObject;
        this.standardBuilder = standardBuilder;
        this.referenceDecorators = new ReferenceDecorator[spanObject.getRefsCount()];
        this.isV2 = true;
    }

    public SpanDecorator(SpanObjectV2.Builder spanBuilder, StandardBuilder standardBuilder) {
        this.spanBuilderV2 = spanBuilder;
        this.standardBuilder = standardBuilder;
        this.isOrigin = false;
        this.referenceDecorators = new ReferenceDecorator[spanBuilder.getRefsCount()];
        this.isV2 = true;
    }

    public int getSpanId() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getSpanId() : this.spanObject.getSpanId();
        }
        return this.isV2 ? this.spanBuilderV2.getSpanId() : this.spanBuilder.getSpanId();
    }

    public int getParentSpanId() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getParentSpanId() : this.spanObject.getParentSpanId();
        }
        return this.isV2 ? this.spanBuilderV2.getParentSpanId() : this.spanBuilder.getParentSpanId();
    }

    public SpanType getSpanType() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getSpanType() : this.spanObject.getSpanType();
        }
        return this.isV2 ? this.spanBuilderV2.getSpanType() : this.spanBuilder.getSpanType();
    }

    public int getSpanTypeValue() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getSpanTypeValue() : this.spanObject.getSpanTypeValue();
        }
        return this.isV2 ? this.spanBuilderV2.getSpanTypeValue() : this.spanBuilder.getSpanTypeValue();
    }

    public SpanLayer getSpanLayer() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getSpanLayer() : this.spanObject.getSpanLayer();
        }
        return this.isV2 ? this.spanBuilderV2.getSpanLayer() : this.spanBuilder.getSpanLayer();
    }

    public int getSpanLayerValue() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getSpanLayerValue() : this.spanObject.getSpanLayerValue();
        }
        return this.isV2 ? this.spanBuilderV2.getSpanLayerValue() : this.spanBuilder.getSpanLayerValue();
    }

    public long getStartTime() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getStartTime() : this.spanObject.getStartTime();
        }
        return this.isV2 ? this.spanBuilderV2.getStartTime() : this.spanBuilder.getStartTime();
    }

    public long getEndTime() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getEndTime() : this.spanObject.getEndTime();
        }
        return this.isV2 ? this.spanBuilderV2.getEndTime() : this.spanBuilder.getEndTime();
    }

    public int getComponentId() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getComponentId() : this.spanObject.getComponentId();
        }
        return this.isV2 ? this.spanBuilderV2.getComponentId() : this.spanBuilder.getComponentId();
    }

    public void setComponentId(int value) {
        if (this.isOrigin) {
            this.toBuilder();
        }
        if (this.isV2) {
            this.spanBuilderV2.setComponentId(value);
        } else {
            this.spanBuilder.setComponentId(value);
        }
    }

    public String getComponent() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getComponent() : this.spanObject.getComponent();
        }
        return this.isV2 ? this.spanBuilderV2.getComponent() : this.spanBuilder.getComponent();
    }

    public void setComponent(String value) {
        if (this.isOrigin) {
            this.toBuilder();
        }
        if (this.isV2) {
            this.spanBuilderV2.setComponent(value);
        } else {
            this.spanBuilder.setComponent(value);
        }
    }

    public int getPeerId() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getPeerId() : this.spanObject.getPeerId();
        }
        return this.isV2 ? this.spanBuilderV2.getPeerId() : this.spanBuilder.getPeerId();
    }

    public void setPeerId(int peerId) {
        if (this.isOrigin) {
            this.toBuilder();
        }
        if (this.isV2) {
            this.spanBuilderV2.setPeerId(peerId);
        } else {
            this.spanBuilder.setPeerId(peerId);
        }
    }

    public String getPeer() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getPeer() : this.spanObject.getPeer();
        }
        return this.isV2 ? this.spanBuilderV2.getPeer() : this.spanBuilder.getPeer();
    }

    public void setPeer(String peer) {
        if (this.isOrigin) {
            this.toBuilder();
        }
        if (this.isV2) {
            this.spanBuilderV2.setPeer(peer);
        } else {
            this.spanBuilder.setPeer(peer);
        }
    }

    public int getOperationNameId() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getOperationNameId() : this.spanObject.getOperationNameId();
        }
        return this.isV2 ? this.spanBuilderV2.getOperationNameId() : this.spanBuilder.getOperationNameId();
    }

    public void setOperationNameId(int value) {
        if (this.isOrigin) {
            this.toBuilder();
        }
        if (this.isV2) {
            this.spanBuilderV2.setOperationNameId(value);
        } else {
            this.spanBuilder.setOperationNameId(value);
        }
    }

    public String getOperationName() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getOperationName() : this.spanObject.getOperationName();
        }
        return this.isV2 ? this.spanBuilderV2.getOperationName() : this.spanBuilder.getOperationName();
    }

    public void setOperationName(String value) {
        if (this.isOrigin) {
            this.toBuilder();
        }
        if (this.isV2) {
            this.spanBuilderV2.setOperationName(value);
        } else {
            this.spanBuilder.setOperationName(value);
        }
    }

    public boolean getIsError() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getIsError() : this.spanObject.getIsError();
        }
        return this.isV2 ? this.spanBuilderV2.getIsError() : this.spanBuilder.getIsError();
    }

    public int getRefsCount() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getRefsCount() : this.spanObject.getRefsCount();
        }
        return this.isV2 ? this.spanBuilderV2.getRefsCount() : this.spanBuilder.getRefsCount();
    }

    public ReferenceDecorator getRefs(int index) {
        if (Objects.isNull(this.referenceDecorators[index])) {
            this.referenceDecorators[index] = this.isOrigin ? (this.isV2 ? new ReferenceDecorator(this.spanObjectV2.getRefs(index), (StandardBuilder)this) : new ReferenceDecorator(this.spanObject.getRefs(index), (StandardBuilder)this)) : (this.isV2 ? new ReferenceDecorator(this.spanBuilderV2.getRefsBuilder(index), (StandardBuilder)this) : new ReferenceDecorator(this.spanBuilder.getRefsBuilder(index), (StandardBuilder)this));
        }
        return this.referenceDecorators[index];
    }

    public List<KeyStringValuePair> getAllTags() {
        if (this.isOrigin) {
            return this.isV2 ? this.spanObjectV2.getTagsList() : this.convert(this.spanObject.getTagsList());
        }
        return this.isV2 ? this.spanBuilderV2.getTagsList() : this.convert(this.spanBuilder.getTagsList());
    }

    @Override
    public void toBuilder() {
        if (this.isOrigin) {
            this.isOrigin = false;
            if (this.isV2) {
                this.spanBuilderV2 = this.spanObjectV2.toBuilder();
            } else {
                this.spanBuilder = this.spanObject.toBuilder();
            }
            this.standardBuilder.toBuilder();
        }
    }

    private List<KeyStringValuePair> convert(List<KeyWithStringValue> list) {
        ArrayList<KeyStringValuePair> result = new ArrayList<KeyStringValuePair>();
        if (list != null) {
            list.forEach(element -> result.add(KeyStringValuePair.newBuilder().setKey(element.getKey()).setValue(element.getValue()).build()));
        }
        return result;
    }
}

