/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.endpoint;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.network.common.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.SpanLayer;
import org.apache.skywalking.apm.network.language.agent.UniqueId;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.source.DatabaseSlowStatement;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.EndpointRelation;
import org.apache.skywalking.oap.server.core.source.RequestType;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.trace.provider.DBLatencyThresholdsAndWatcher;
import org.apache.skywalking.oap.server.receiver.trace.provider.TraceServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.ReferenceDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SegmentCoreInfo;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SpanDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.EntrySpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.ExitSpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.GlobalTraceIdsListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.SpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.SpanListenerFactory;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.endpoint.SourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiScopesSpanListener
implements EntrySpanListener,
ExitSpanListener,
GlobalTraceIdsListener {
    private static final Logger logger = LoggerFactory.getLogger(MultiScopesSpanListener.class);
    private final SourceReceiver sourceReceiver;
    private final ServiceInstanceInventoryCache instanceInventoryCache;
    private final ServiceInventoryCache serviceInventoryCache;
    private final EndpointInventoryCache endpointInventoryCache;
    private final List<SourceBuilder> entrySourceBuilders;
    private final List<SourceBuilder> exitSourceBuilders;
    private final List<DatabaseSlowStatement> slowDatabaseAccesses;
    private final TraceServiceModuleConfig config;
    private final NetworkAddressInventoryCache networkAddressInventoryCache;
    private SpanDecorator entrySpanDecorator;
    private long minuteTimeBucket;
    private String traceId;

    private MultiScopesSpanListener(ModuleManager moduleManager, TraceServiceModuleConfig config) {
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.entrySourceBuilders = new LinkedList<SourceBuilder>();
        this.exitSourceBuilders = new LinkedList<SourceBuilder>();
        this.slowDatabaseAccesses = new ArrayList<DatabaseSlowStatement>(10);
        this.instanceInventoryCache = (ServiceInstanceInventoryCache)moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
        this.serviceInventoryCache = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        this.endpointInventoryCache = (EndpointInventoryCache)moduleManager.find("core").provider().getService(EndpointInventoryCache.class);
        this.networkAddressInventoryCache = (NetworkAddressInventoryCache)moduleManager.find("core").provider().getService(NetworkAddressInventoryCache.class);
        this.config = config;
        this.traceId = null;
    }

    @Override
    public boolean containsPoint(SpanListener.Point point) {
        return SpanListener.Point.Entry.equals((Object)point) || SpanListener.Point.Exit.equals((Object)point) || SpanListener.Point.TraceIds.equals((Object)point);
    }

    @Override
    public void parseEntry(SpanDecorator spanDecorator, SegmentCoreInfo segmentCoreInfo) {
        this.minuteTimeBucket = segmentCoreInfo.getMinuteTimeBucket();
        if (spanDecorator.getRefsCount() > 0) {
            for (int i = 0; i < spanDecorator.getRefsCount(); ++i) {
                ReferenceDecorator reference = spanDecorator.getRefs(i);
                SourceBuilder sourceBuilder = new SourceBuilder();
                if (reference.getParentEndpointId() == -1) {
                    sourceBuilder.setSourceEndpointId(1);
                } else {
                    sourceBuilder.setSourceEndpointId(reference.getParentEndpointId());
                }
                int networkAddressId = reference.getNetworkAddressId();
                int serviceIdByPeerId = this.serviceInventoryCache.getServiceId(networkAddressId);
                String address = this.networkAddressInventoryCache.get(networkAddressId).getName();
                if (spanDecorator.getSpanLayer().equals((Object)SpanLayer.MQ) || this.config.getUninstrumentedGatewaysConfig().isAddressConfiguredAsGateway(address)) {
                    int instanceIdByPeerId = this.instanceInventoryCache.getServiceInstanceId(serviceIdByPeerId, networkAddressId);
                    sourceBuilder.setSourceServiceInstanceId(instanceIdByPeerId);
                    sourceBuilder.setSourceServiceId(serviceIdByPeerId);
                } else {
                    sourceBuilder.setSourceServiceInstanceId(reference.getParentServiceInstanceId());
                    sourceBuilder.setSourceServiceId(this.instanceInventoryCache.get(reference.getParentServiceInstanceId()).getServiceId());
                }
                sourceBuilder.setDestEndpointId(spanDecorator.getOperationNameId());
                sourceBuilder.setDestServiceInstanceId(segmentCoreInfo.getServiceInstanceId());
                sourceBuilder.setDestServiceId(segmentCoreInfo.getServiceId());
                sourceBuilder.setDetectPoint(DetectPoint.SERVER);
                sourceBuilder.setComponentId(spanDecorator.getComponentId());
                this.setPublicAttrs(sourceBuilder, spanDecorator);
                this.entrySourceBuilders.add(sourceBuilder);
            }
        } else {
            SourceBuilder sourceBuilder = new SourceBuilder();
            sourceBuilder.setSourceEndpointId(1);
            sourceBuilder.setSourceServiceInstanceId(1);
            sourceBuilder.setSourceServiceId(1);
            sourceBuilder.setDestEndpointId(spanDecorator.getOperationNameId());
            sourceBuilder.setDestServiceInstanceId(segmentCoreInfo.getServiceInstanceId());
            sourceBuilder.setDestServiceId(segmentCoreInfo.getServiceId());
            sourceBuilder.setDetectPoint(DetectPoint.SERVER);
            sourceBuilder.setComponentId(spanDecorator.getComponentId());
            this.setPublicAttrs(sourceBuilder, spanDecorator);
            this.entrySourceBuilders.add(sourceBuilder);
        }
        this.entrySpanDecorator = spanDecorator;
    }

    @Override
    public void parseExit(SpanDecorator spanDecorator, SegmentCoreInfo segmentCoreInfo) {
        if (this.minuteTimeBucket == 0L) {
            this.minuteTimeBucket = segmentCoreInfo.getMinuteTimeBucket();
        }
        SourceBuilder sourceBuilder = new SourceBuilder();
        int peerId = spanDecorator.getPeerId();
        if (peerId == 0) {
            return;
        }
        int destServiceId = this.serviceInventoryCache.getServiceId(peerId);
        int mappingServiceId = this.serviceInventoryCache.get(destServiceId).getMappingServiceId();
        int destInstanceId = this.instanceInventoryCache.getServiceInstanceId(destServiceId, peerId);
        int mappingServiceInstanceId = this.instanceInventoryCache.get(destInstanceId).getMappingServiceInstanceId();
        sourceBuilder.setSourceServiceInstanceId(segmentCoreInfo.getServiceInstanceId());
        sourceBuilder.setSourceServiceId(segmentCoreInfo.getServiceId());
        if (0 == mappingServiceId) {
            sourceBuilder.setDestServiceId(destServiceId);
        } else {
            sourceBuilder.setDestServiceId(mappingServiceId);
        }
        if (0 == mappingServiceInstanceId) {
            sourceBuilder.setDestServiceInstanceId(destInstanceId);
        } else {
            sourceBuilder.setDestServiceInstanceId(mappingServiceInstanceId);
        }
        sourceBuilder.setDetectPoint(DetectPoint.CLIENT);
        sourceBuilder.setComponentId(spanDecorator.getComponentId());
        this.setPublicAttrs(sourceBuilder, spanDecorator);
        this.exitSourceBuilders.add(sourceBuilder);
        if (sourceBuilder.getType().equals((Object)RequestType.DATABASE)) {
            boolean isSlowDBAccess = false;
            DatabaseSlowStatement statement = new DatabaseSlowStatement();
            statement.setId(segmentCoreInfo.getSegmentId() + "-" + spanDecorator.getSpanId());
            statement.setDatabaseServiceId(sourceBuilder.getDestServiceId());
            statement.setLatency((long)sourceBuilder.getLatency());
            statement.setTimeBucket(TimeBucket.getRecordTimeBucket((long)segmentCoreInfo.getStartTime()));
            statement.setTraceId(this.traceId);
            for (KeyStringValuePair tag : spanDecorator.getAllTags()) {
                if ("db.statement".equals(tag.getKey())) {
                    String sqlStatement = tag.getValue();
                    if (StringUtil.isEmpty((String)sqlStatement)) {
                        statement.setStatement("[No statement]/" + sourceBuilder.getDestEndpointName());
                        continue;
                    }
                    if (sqlStatement.length() > this.config.getMaxSlowSQLLength()) {
                        statement.setStatement(sqlStatement.substring(0, this.config.getMaxSlowSQLLength()));
                        continue;
                    }
                    statement.setStatement(sqlStatement);
                    continue;
                }
                if (!"db.type".equals(tag.getKey())) continue;
                String dbType = tag.getValue();
                DBLatencyThresholdsAndWatcher thresholds = this.config.getDbLatencyThresholdsAndWatcher();
                int threshold = thresholds.getThreshold(dbType);
                if (sourceBuilder.getLatency() <= threshold) continue;
                isSlowDBAccess = true;
            }
            if (isSlowDBAccess) {
                this.slowDatabaseAccesses.add(statement);
            }
        }
    }

    private void setPublicAttrs(SourceBuilder sourceBuilder, SpanDecorator spanDecorator) {
        long latency = spanDecorator.getEndTime() - spanDecorator.getStartTime();
        sourceBuilder.setLatency((int)latency);
        sourceBuilder.setResponseCode(0);
        sourceBuilder.setStatus(!spanDecorator.getIsError());
        switch (spanDecorator.getSpanLayer()) {
            case Http: {
                sourceBuilder.setType(RequestType.HTTP);
                break;
            }
            case Database: {
                sourceBuilder.setType(RequestType.DATABASE);
                break;
            }
            default: {
                sourceBuilder.setType(RequestType.RPC);
            }
        }
        sourceBuilder.setSourceServiceName(this.serviceInventoryCache.get(sourceBuilder.getSourceServiceId()).getName());
        sourceBuilder.setSourceServiceInstanceName(this.instanceInventoryCache.get(sourceBuilder.getSourceServiceInstanceId()).getName());
        if (sourceBuilder.getSourceEndpointId() != 0) {
            sourceBuilder.setSourceEndpointName(this.endpointInventoryCache.get(sourceBuilder.getSourceEndpointId()).getName());
        }
        sourceBuilder.setDestServiceName(this.serviceInventoryCache.get(sourceBuilder.getDestServiceId()).getName());
        sourceBuilder.setDestServiceInstanceName(this.instanceInventoryCache.get(sourceBuilder.getDestServiceInstanceId()).getName());
        if (sourceBuilder.getDestEndpointId() != 0) {
            sourceBuilder.setDestEndpointName(this.endpointInventoryCache.get(sourceBuilder.getDestEndpointId()).getName());
        }
    }

    @Override
    public void build() {
        this.entrySourceBuilders.forEach(entrySourceBuilder -> {
            entrySourceBuilder.setTimeBucket(this.minuteTimeBucket);
            this.sourceReceiver.receive((Source)entrySourceBuilder.toAll());
            this.sourceReceiver.receive((Source)entrySourceBuilder.toService());
            this.sourceReceiver.receive((Source)entrySourceBuilder.toServiceInstance());
            this.sourceReceiver.receive((Source)entrySourceBuilder.toEndpoint());
            this.sourceReceiver.receive((Source)entrySourceBuilder.toServiceRelation());
            this.sourceReceiver.receive((Source)entrySourceBuilder.toServiceInstanceRelation());
            EndpointRelation endpointRelation = entrySourceBuilder.toEndpointRelation();
            if (endpointRelation != null) {
                this.sourceReceiver.receive((Source)endpointRelation);
            }
        });
        this.exitSourceBuilders.forEach(exitSourceBuilder -> {
            if (Objects.nonNull(this.entrySpanDecorator)) {
                exitSourceBuilder.setSourceEndpointId(this.entrySpanDecorator.getOperationNameId());
            } else {
                exitSourceBuilder.setSourceEndpointId(1);
            }
            exitSourceBuilder.setSourceEndpointName(this.endpointInventoryCache.get(exitSourceBuilder.getSourceEndpointId()).getName());
            exitSourceBuilder.setTimeBucket(this.minuteTimeBucket);
            this.sourceReceiver.receive((Source)exitSourceBuilder.toServiceRelation());
            this.sourceReceiver.receive((Source)exitSourceBuilder.toServiceInstanceRelation());
            if (RequestType.DATABASE.equals((Object)exitSourceBuilder.getType())) {
                this.sourceReceiver.receive((Source)exitSourceBuilder.toDatabaseAccess());
            }
        });
        this.slowDatabaseAccesses.forEach(arg_0 -> ((SourceReceiver)this.sourceReceiver).receive(arg_0));
    }

    @Override
    public void parseGlobalTraceId(UniqueId uniqueId, SegmentCoreInfo segmentCoreInfo) {
        if (this.traceId == null) {
            StringBuilder traceIdBuilder = new StringBuilder();
            for (int i = 0; i < uniqueId.getIdPartsList().size(); ++i) {
                if (i == 0) {
                    traceIdBuilder.append(uniqueId.getIdPartsList().get(i));
                    continue;
                }
                traceIdBuilder.append(".").append(uniqueId.getIdPartsList().get(i));
            }
            this.traceId = traceIdBuilder.toString();
        }
    }

    public static class Factory
    implements SpanListenerFactory {
        @Override
        public SpanListener create(ModuleManager moduleManager, TraceServiceModuleConfig config) {
            return new MultiScopesSpanListener(moduleManager, config);
        }
    }
}

