/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.network.language.agent.SpanLayer;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.trace.provider.TraceServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SegmentCoreInfo;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SpanDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.EntrySpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.SpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.SpanListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInstanceMappingSpanListener
implements EntrySpanListener {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstanceMappingSpanListener.class);
    private final IServiceInstanceInventoryRegister serviceInstanceInventoryRegister;
    private final TraceServiceModuleConfig config;
    private final ServiceInventoryCache serviceInventoryCache;
    private final ServiceInstanceInventoryCache serviceInstanceInventoryCache;
    private final NetworkAddressInventoryCache networkAddressInventoryCache;
    private final List<ServiceInstanceMapping> serviceInstanceMappings = new ArrayList<ServiceInstanceMapping>();
    private final List<Integer> serviceInstancesToResetMapping = new ArrayList<Integer>();

    public ServiceInstanceMappingSpanListener(ModuleManager moduleManager, TraceServiceModuleConfig config) {
        this.serviceInstanceInventoryCache = (ServiceInstanceInventoryCache)moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
        this.serviceInventoryCache = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        this.serviceInstanceInventoryRegister = (IServiceInstanceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInstanceInventoryRegister.class);
        this.networkAddressInventoryCache = (NetworkAddressInventoryCache)moduleManager.find("core").provider().getService(NetworkAddressInventoryCache.class);
        this.config = config;
    }

    @Override
    public void parseEntry(SpanDecorator spanDecorator, SegmentCoreInfo segmentCoreInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug("service instance mapping listener parse reference");
        }
        if (!spanDecorator.getSpanLayer().equals((Object)SpanLayer.MQ) && spanDecorator.getRefsCount() > 0) {
            for (int i = 0; i < spanDecorator.getRefsCount(); ++i) {
                int networkAddressId = spanDecorator.getRefs(i).getNetworkAddressId();
                String address = this.networkAddressInventoryCache.get(networkAddressId).getName();
                int serviceInstanceId = this.serviceInstanceInventoryCache.getServiceInstanceId(this.serviceInventoryCache.getServiceId(networkAddressId), networkAddressId);
                if (this.config.getUninstrumentedGatewaysConfig().isAddressConfiguredAsGateway(address)) {
                    ServiceInstanceInventory instanceInventory;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} is configured as gateway, will reset its mapping service instance id", (Object)serviceInstanceId);
                    }
                    if ((instanceInventory = this.serviceInstanceInventoryCache.get(serviceInstanceId)).getMappingServiceInstanceId() == 0 || this.serviceInstancesToResetMapping.contains(serviceInstanceId)) continue;
                    this.serviceInstancesToResetMapping.add(serviceInstanceId);
                    continue;
                }
                ServiceInstanceMapping serviceMapping = new ServiceInstanceMapping();
                serviceMapping.setServiceInstanceId(serviceInstanceId);
                serviceMapping.setMappingServiceInstanceId(segmentCoreInfo.getServiceInstanceId());
                this.serviceInstanceMappings.add(serviceMapping);
            }
        }
    }

    @Override
    public void build() {
        this.serviceInstanceMappings.forEach(instanceMapping -> {
            if (logger.isDebugEnabled()) {
                logger.debug("service instance mapping listener build, service id: {}, mapping service id: {}", (Object)instanceMapping.getServiceInstanceId(), (Object)instanceMapping.getMappingServiceInstanceId());
            }
            this.serviceInstanceInventoryRegister.updateMapping(instanceMapping.getServiceInstanceId(), instanceMapping.getMappingServiceInstanceId());
        });
        this.serviceInstancesToResetMapping.forEach(instanceId -> {
            if (logger.isDebugEnabled()) {
                logger.debug("service instance mapping listener build, reset mapping of service id: {}", instanceId);
            }
            this.serviceInstanceInventoryRegister.resetMapping(instanceId.intValue());
        });
    }

    @Override
    public boolean containsPoint(SpanListener.Point point) {
        return SpanListener.Point.Entry.equals((Object)point);
    }

    private static class ServiceInstanceMapping {
        private int serviceInstanceId;
        private int mappingServiceInstanceId;

        private ServiceInstanceMapping() {
        }

        public int getServiceInstanceId() {
            return this.serviceInstanceId;
        }

        public int getMappingServiceInstanceId() {
            return this.mappingServiceInstanceId;
        }

        public void setServiceInstanceId(int serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        public void setMappingServiceInstanceId(int mappingServiceInstanceId) {
            this.mappingServiceInstanceId = mappingServiceInstanceId;
        }
    }

    public static class Factory
    implements SpanListenerFactory {
        @Override
        public SpanListener create(ModuleManager moduleManager, TraceServiceModuleConfig config) {
            return new ServiceInstanceMappingSpanListener(moduleManager, config);
        }
    }
}

