/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.network.language.agent.SpanLayer;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.trace.provider.TraceServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SegmentCoreInfo;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SpanDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.EntrySpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.SpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.SpanListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMappingSpanListener
implements EntrySpanListener {
    private static final Logger logger = LoggerFactory.getLogger(ServiceMappingSpanListener.class);
    private final IServiceInventoryRegister serviceInventoryRegister;
    private final TraceServiceModuleConfig config;
    private final ServiceInventoryCache serviceInventoryCache;
    private final NetworkAddressInventoryCache networkAddressInventoryCache;
    private final List<ServiceMapping> serviceMappings = new ArrayList<ServiceMapping>();
    private final List<Integer> servicesToResetMapping = new ArrayList<Integer>();

    private ServiceMappingSpanListener(ModuleManager moduleManager, TraceServiceModuleConfig config) {
        this.serviceInventoryCache = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        this.networkAddressInventoryCache = (NetworkAddressInventoryCache)moduleManager.find("core").provider().getService(NetworkAddressInventoryCache.class);
        this.serviceInventoryRegister = (IServiceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInventoryRegister.class);
        this.config = config;
    }

    @Override
    public boolean containsPoint(SpanListener.Point point) {
        return SpanListener.Point.Entry.equals((Object)point);
    }

    @Override
    public void parseEntry(SpanDecorator spanDecorator, SegmentCoreInfo segmentCoreInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug("service mapping listener parse reference");
        }
        if (!spanDecorator.getSpanLayer().equals((Object)SpanLayer.MQ) && spanDecorator.getRefsCount() > 0) {
            for (int i = 0; i < spanDecorator.getRefsCount(); ++i) {
                int networkAddressId = spanDecorator.getRefs(i).getNetworkAddressId();
                String address = this.networkAddressInventoryCache.get(networkAddressId).getName();
                int serviceId = this.serviceInventoryCache.getServiceId(networkAddressId);
                if (this.config.getUninstrumentedGatewaysConfig().isAddressConfiguredAsGateway(address)) {
                    ServiceInventory serviceInventory;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} is configured as gateway, will reset its mapping service id", (Object)serviceId);
                    }
                    if ((serviceInventory = this.serviceInventoryCache.get(serviceId)).getMappingServiceId() == 0 || this.servicesToResetMapping.contains(serviceId)) continue;
                    this.servicesToResetMapping.add(serviceId);
                    continue;
                }
                ServiceMapping serviceMapping = new ServiceMapping();
                serviceMapping.setServiceId(serviceId);
                serviceMapping.setMappingServiceId(segmentCoreInfo.getServiceId());
                this.serviceMappings.add(serviceMapping);
            }
        }
    }

    @Override
    public void build() {
        this.serviceMappings.forEach(serviceMapping -> {
            if (logger.isDebugEnabled()) {
                logger.debug("service mapping listener build, service id: {}, mapping service id: {}", (Object)serviceMapping.getServiceId(), (Object)serviceMapping.getMappingServiceId());
            }
            this.serviceInventoryRegister.updateMapping(serviceMapping.getServiceId(), serviceMapping.getMappingServiceId());
        });
        this.servicesToResetMapping.forEach(serviceId -> {
            if (logger.isDebugEnabled()) {
                logger.debug("service mapping listener build, reset mapping of service id: {}", serviceId);
            }
            this.serviceInventoryRegister.resetMapping(serviceId.intValue());
        });
    }

    private static class ServiceMapping {
        private int serviceId;
        private int mappingServiceId;

        private ServiceMapping() {
        }

        public void setServiceId(int serviceId) {
            this.serviceId = serviceId;
        }

        public void setMappingServiceId(int mappingServiceId) {
            this.mappingServiceId = mappingServiceId;
        }

        public int getServiceId() {
            return this.serviceId;
        }

        public int getMappingServiceId() {
            return this.mappingServiceId;
        }
    }

    public static class Factory
    implements SpanListenerFactory {
        @Override
        public SpanListener create(ModuleManager moduleManager, TraceServiceModuleConfig config) {
            return new ServiceMappingSpanListener(moduleManager, config);
        }
    }
}

