/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization;

import com.google.common.base.Strings;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.register.service.IEndpointInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.INetworkAddressInventoryRegister;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.ReferenceDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization.IdExchanger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceIdExchanger
implements IdExchanger<ReferenceDecorator> {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceIdExchanger.class);
    private static ReferenceIdExchanger EXCHANGER;
    private final IEndpointInventoryRegister endpointInventoryRegister;
    private final ServiceInstanceInventoryCache serviceInstanceInventoryCache;
    private final INetworkAddressInventoryRegister networkAddressInventoryRegister;

    public static ReferenceIdExchanger getInstance(ModuleManager moduleManager) {
        if (EXCHANGER == null) {
            EXCHANGER = new ReferenceIdExchanger(moduleManager);
        }
        return EXCHANGER;
    }

    private ReferenceIdExchanger(ModuleManager moduleManager) {
        this.endpointInventoryRegister = (IEndpointInventoryRegister)moduleManager.find("core").provider().getService(IEndpointInventoryRegister.class);
        this.networkAddressInventoryRegister = (INetworkAddressInventoryRegister)moduleManager.find("core").provider().getService(INetworkAddressInventoryRegister.class);
        this.serviceInstanceInventoryCache = (ServiceInstanceInventoryCache)moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
    }

    @Override
    public boolean exchange(ReferenceDecorator standardBuilder, int serviceId) {
        boolean exchanged = true;
        if (standardBuilder.getEntryEndpointId() == 0) {
            String entryEndpointName = Strings.isNullOrEmpty((String)standardBuilder.getEntryEndpointName()) ? "{domain}" : standardBuilder.getEntryEndpointName();
            int entryServiceId = this.serviceInstanceInventoryCache.get(standardBuilder.getEntryServiceInstanceId()).getServiceId();
            int entryEndpointId = this.getEndpointId(entryServiceId, entryEndpointName);
            if (entryEndpointId == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("entry endpoint name: {} from service id: {} exchange failed", (Object)entryEndpointName, (Object)entryServiceId);
                }
                exchanged = false;
            } else {
                standardBuilder.toBuilder();
                standardBuilder.setEntryEndpointId(entryEndpointId);
                standardBuilder.setEntryEndpointName("");
            }
        }
        if (standardBuilder.getParentEndpointId() == 0) {
            String parentEndpointName = Strings.isNullOrEmpty((String)standardBuilder.getParentEndpointName()) ? "{domain}" : standardBuilder.getParentEndpointName();
            int parentServiceId = this.serviceInstanceInventoryCache.get(standardBuilder.getParentServiceInstanceId()).getServiceId();
            int parentEndpointId = this.getEndpointId(parentServiceId, parentEndpointName);
            if (parentEndpointId == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("parent endpoint name: {} from service id: {} exchange failed", (Object)parentEndpointName, (Object)parentServiceId);
                }
                exchanged = false;
            } else {
                standardBuilder.toBuilder();
                standardBuilder.setParentEndpointId(parentEndpointId);
                standardBuilder.setParentEndpointName("");
            }
        }
        if (standardBuilder.getNetworkAddressId() == 0 && !Strings.isNullOrEmpty((String)standardBuilder.getNetworkAddress())) {
            int networkAddressId = this.networkAddressInventoryRegister.getOrCreate(standardBuilder.getNetworkAddress(), null);
            if (networkAddressId == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("network getAddress: {} from service id: {} exchange failed", (Object)standardBuilder.getNetworkAddress(), (Object)serviceId);
                }
                exchanged = false;
            } else {
                standardBuilder.toBuilder();
                standardBuilder.setNetworkAddressId(networkAddressId);
                standardBuilder.setNetworkAddress("");
            }
        }
        return exchanged;
    }

    private int getEndpointId(int serviceId, String endpointName) {
        int endpointId = this.endpointInventoryRegister.get(serviceId, endpointName, DetectPoint.SERVER.ordinal());
        if (endpointId == 0 && (endpointId = this.endpointInventoryRegister.get(serviceId, endpointName, DetectPoint.CLIENT.ordinal())) == 0) {
            endpointId = this.endpointInventoryRegister.get(serviceId, endpointName, DetectPoint.UNRECOGNIZED.ordinal());
        }
        return endpointId;
    }
}

